package ebuild.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.json.simple.JSONValue;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JSONUtil {

    static ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){
        public List creatArrayContainer() {
            return new ArrayList();
        }

        public Map createObjectContainer() {
            return new LinkedHashMap();
        }
    };

    
    static public Object readObject(Reader r) throws IOException, ParseException{
        return new JSONParser().parse(r);
    }
    
    static public Object readObject(String s){
        try {
            return new JSONParser().parse(s, CONTAINER_FACTORY);
        } catch (ParseException e) {
            throw new RuntimeException("property value not valid json: "+s);
        }
    }
    
    
    static public Map readMap(Reader r) throws IOException, ParseException{
        Object o = readObject(r);
        if(!(o instanceof Map)){
            throw new RuntimeException("expected map, got "+o);
        }
        return (Map)o;
    }
    
    static public List readList(String s){
        Object o = readObject(s);
        if(!(o instanceof List)){
            throw new RuntimeException("expected map, got "+o);
        }
        return (List)o;
    }
    
    static public Map readMap(String s){
        Object o = readObject(s);
        if(!(o instanceof Map)){
            throw new RuntimeException("expected map, got "+o);
        }
        return (Map)o;
    }


    static public void writeObject(Writer w, Object o) throws IOException{
        try{
            JSONValue.writeJSONString(o, w);
        }finally{
            w.close();
        }
    }

}
