package ebuild.util;

import java.util.Collection;

public class StringUtil {
	
	static public String reverseString(String s){
		if(s==null) return null;
		StringBuffer buff = new StringBuffer(s);
		return buff.reverse().toString();
	}

	static public String lpad(int l, String s, char pad){
		StringBuffer r = new StringBuffer(l);
		for(int i=0; i<l-s.length(); i++)
			r.append(pad);
		r.append(s);
		return r.toString();
	}
	static public String lpad(int l, String s){
		return lpad(l, s, ' ');
	}
	static public String rpad(int l, String s, char pad){
		StringBuffer r = new StringBuffer(l);
		r.append(s);
		for(int i=0; i<l-s.length(); i++)
			r.append(pad);
		return r.toString();
	}
	static public String rpad(int l, String s){
		return rpad(l, s, ' ');
	}
	static public String join(String separator, Collection args){
		return join(separator,args.toArray());
	}
	static public String join(String separator, Object... args){
		String[] strs = new String[args.length]; 
		for(int i=0; i<args.length; i++){
			strs[i] = args[i].toString();
		}
		return join(separator, strs);
	}
	static public String join(String separator, String... strs){
		int l = 0;
		for(String s: strs){
			l += (s==null?4:s.length())+1;
		}		
		StringBuffer r = new StringBuffer(l);
		for(String s: strs){
			if(r.length()>0)r.append(separator);
			r.append(s==null?"null":s);
		}
		return r.toString();
	}
	static public String join(String separator,  int... args){
		StringBuffer r = new StringBuffer();
		for(int i: args){
			if(r.length()>0)r.append(separator);
			r.append(i);
		}
		return r.toString();
	}
	
	static public String camelCaseToDashed(String s) {
        StringBuilder r = new StringBuilder(s.length()+2);
        for(int i=0; i<s.length(); i++){
            char c = s.charAt(i);
            if(Character.isUpperCase(c)){
                if(i>0) r.append('-');
                c = Character.toLowerCase(c);
            }
            r.append(c);
        }
        return r.toString();
    }
	static public String pascalCaseFromDashed(String s) { return camelCaseFromDashed(s, true); }
    static public String camelCaseFromDashed(String s) { return camelCaseFromDashed(s,false); }
    static public String camelCaseFromDashed(String s, boolean capitaliseFirst){
        StringBuilder r = new StringBuilder(s.length());
        boolean capitalise = capitaliseFirst;
        for(int i=0; i<s.length(); i++){
            char c = s.charAt(i);
            if(c=='-'){
                capitalise = true;
            }else{
                if(capitalise){
                    capitalise = false;
                    c = Character.toUpperCase(c);
                }
                r.append(c);
            }
        }
        return r.toString();
	}

    static public boolean isEmptyString(String s) {
        if(s==null) return true;
        return "".equals(s.trim());
    }

    static public boolean isEmptyString(Object o) {
        if(o==null || o instanceof String)
        	return isEmptyString((String)o);
        return false;
    }

    static public Integer tryParseInt(String s) {
		try{
    		return Integer.parseInt(s);
		}catch(Exception e){
			return null;
		}
    }
}
