/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;

public class IOUtil {
    public static void pipeKeepOpen(InputStream in, OutputStream out, int buffer, ProgressListener listener) throws IOException {
        int bytesRead;
        byte[] buff = new byte[16384];
        while ((bytesRead = in.read(buff)) != -1) {
            out.write(buff, 0, bytesRead);
            if (listener == null) continue;
            listener.progress(bytesRead);
        }
    }

    public static void pipeKeepOpen(InputStream in, OutputStream out) throws IOException {
        IOUtil.pipeKeepOpen(in, out, 16384, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipe(InputStream in, OutputStream out, int buffer, ProgressListener listener) throws IOException {
        try {
            IOUtil.pipeKeepOpen(in, out, buffer, null);
        }
        finally {
            out.close();
        }
    }

    public static void pipe(InputStream in, OutputStream out) throws IOException {
        IOUtil.pipe(in, out, 16384, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipe(Reader in, Writer out) throws IOException {
        try {
            int bytesRead;
            char[] buff = new char[16384];
            while ((bytesRead = in.read(buff)) != -1) {
                out.write(buff, 0, bytesRead);
            }
        }
        finally {
            out.close();
        }
    }

    public static byte[] inputStreamToBytes(InputStream is) throws IOException {
        return IOUtil.inputStreamToBytes(is, 32);
    }

    public static byte[] inputStreamToBytes(InputStream is, int size) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
        IOUtil.pipe(is, baos);
        return baos.toByteArray();
    }

    public static void stringToWriter(String s, Writer w) throws IOException {
        IOUtil.pipe(new StringReader(s), w);
    }

    public static String readerToString(Reader r) throws IOException {
        CharArrayWriter w = new CharArrayWriter();
        IOUtil.pipe(r, w);
        return w.toString();
    }

    public static String readerToString(Reader r, int length) throws IOException {
        CharArrayWriter w = new CharArrayWriter(length);
        IOUtil.pipe(r, w);
        return w.toString();
    }

    public static void bytesToFile(byte[] bytes, File f) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        IOUtil.inputStreamToFile(in, f);
    }

    public static void inputStreamToFile(InputStream in, File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        IOUtil.pipe(in, out);
    }

    public static void stringToFile(String s, File f, String charset) throws IOException {
        IOUtil.bytesToFile(s.getBytes(charset), f);
    }

    public static void stringToFile(String s, File f) throws IOException {
        IOUtil.stringToFile(s, f, "UTF-8");
    }

    public static String fileToString(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtil.pipe(in, out);
        return new String(out.toByteArray(), "UTF-8");
    }

    public static String resourceToString(Class class_, String resource) throws IOException {
        InputStreamReader ir = new InputStreamReader(class_.getResource(resource).openStream());
        return IOUtil.readerToString(ir);
    }

    public static interface ProgressListener {
        public void progress(int var1);
    }
}

