/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import ebuild.util.IOUtil;
import ebuild.util.ZipUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static final FileFilter FILEFILTER_ALL = new FileFilter(){

        public boolean accept(File pathname) {
            return true;
        }
    };
    public static final CopyFilter COPYFILTER_ALL = new CopyFilter(){

        public boolean accept(File source, File dest) {
            return true;
        }
    };
    public static final CopyFilter COPYFILTER_IFNEWER = new CopyFilter(){

        public boolean accept(File source, File dest) {
            if (source.isDirectory()) {
                return true;
            }
            return dest.lastModified() >= source.lastModified();
        }
    };

    public static Date readTimestampFile(File dir) {
        try {
            File f = new File(dir, "timestamp");
            if (!f.isFile()) {
                return null;
            }
            return Timestamp.valueOf(IOUtil.fileToString(new File(dir, "timestamp")));
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static void writeTimestampFile(File dir, Date timestamp) {
        try {
            IOUtil.stringToFile(new Timestamp(timestamp.getTime()).toString(), new File(dir, "timestamp"));
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static boolean fileExists(File dir, String name) {
        return new File(dir, name).isFile();
    }

    public static boolean hasFile(File dir, final FileFilter filter) throws Exception {
        return (Boolean)new Traversal(){
            boolean found = false;

            public void onFile(File f) {
                if (filter.accept(f)) {
                    this.found = true;
                    this.exit = true;
                }
            }

            public Object finish() {
                return this.found;
            }
        }.go(dir);
    }

    public static boolean hasFileWithSuffix(File dir, final String suffix) throws Exception {
        return FileUtil.hasFile(dir, new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(suffix);
            }
        });
    }

    public static boolean deleteDir(File dir) {
        if (!dir.exists()) {
            return true;
        }
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String relativePath2Parent(File child, File parent) {
        if (parent.equals(child)) {
            return ".";
        }
        String path = "..";
        File p = child;
        while (!(p = p.getParentFile()).equals(parent)) {
            path = "../" + path;
        }
        return path;
    }

    public static String relativePath2Child(File parent, File child) {
        if (parent.equals(child)) {
            return ".";
        }
        String path = child.getName();
        File p = child;
        while (!(p = p.getParentFile()).equals(parent)) {
            path = p.getName() + "/" + path;
        }
        return path;
    }

    @Deprecated
    public static String relativePath(File ancestor, File f) {
        return FileUtil.relativePath2Child(ancestor, f);
    }

    public static String fileLastSuffix(File f) {
        return FileUtil.fileLastSuffix(f.getName());
    }

    public static String fileLastSuffix(String name) {
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        return name.substring(dot + 1);
    }

    public static String fileSuffix(File f) {
        return FileUtil.fileSuffix(f.getName());
    }

    public static String fileSuffix(String name) {
        int dot = name.indexOf(46);
        if (dot == -1) {
            return null;
        }
        return name.substring(dot + 1);
    }

    public static String replaceSuffix(String name, String suffix) {
        name = FileUtil.removeSuffix(name) + "." + suffix;
        return name;
    }

    public static String removeSuffix(String name) {
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return name;
        }
        name = name.substring(0, dot);
        return name;
    }

    public static File copyToDirIfNewer(File f, File dir) throws IOException {
        File r = new File(dir, f.getName());
        FileUtil.copyIfNewer(f, r);
        return r;
    }

    public static File copyToDir(File f, File dir) throws IOException {
        File r = new File(dir, f.getName());
        FileUtil.copy(f, r);
        return r;
    }

    public static void copyFileIfNewer(File source, File dest) throws IOException {
        if (COPYFILTER_IFNEWER.accept(source, dest)) {
            return;
        }
        FileUtil.doCopyFile(source, dest);
    }

    public static void copyFile(File source, File dest) throws IOException {
        FileUtil.doCopyFile(source, dest);
    }

    public static void copyIfNewer(File source, File dest) throws IOException {
        FileUtil.copy(source, dest, COPYFILTER_IFNEWER);
    }

    public static void copy(File source, File dest) throws IOException {
        FileUtil.copy(source, dest, COPYFILTER_ALL);
    }

    public static File createTempDirectory() throws IOException {
        return FileUtil.createTempDirectory("directory");
    }

    public static File createTempDirectory(String name) throws IOException {
        File r = File.createTempFile(name, null);
        r.delete();
        r.mkdirs();
        return r;
    }

    public static File createTempFile() throws IOException {
        return FileUtil.createTempFile("file");
    }

    public static File createTempFile(String name) throws IOException {
        return File.createTempFile(name, null);
    }

    public static CopyFilter newCopyFilter(final FileFilter filter) {
        return new CopyFilter(){

            public boolean accept(File source, File dest) {
                return filter.accept(source);
            }
        };
    }

    public static void copy(File source, File dest, FileFilter filter) throws IOException {
        FileUtil.copy(source, dest, FileUtil.newCopyFilter(filter));
    }

    public static void copy(File source, File dest, CopyFilter filter) throws IOException {
        if (!filter.accept(source, dest)) {
            return;
        }
        if (source.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdirs();
            }
            for (File source2 : source.listFiles()) {
                FileUtil.copy(source2, new File(dest, source2.getName()), filter);
            }
        } else {
            if (!source.exists()) {
                throw new IOException("File or directory does not exist: " + source);
            }
            FileUtil.doCopyFile(source, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File source, File dest) throws IOException {
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            dest.getParentFile().mkdirs();
            in = new FileInputStream(source).getChannel();
            out = new FileOutputStream(dest).getChannel();
            long size = ((FileChannel)in).size();
            MappedByteBuffer buf = ((FileChannel)in).map(FileChannel.MapMode.READ_ONLY, 0L, size);
            ((FileChannel)out).write(buf);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static long deepLastModified(File root) {
        return (Long)new Traversal<Long, RuntimeException>(){
            long lastModified = Long.MIN_VALUE;

            @Override
            public void onFile(File f) {
                this.lastModified = Math.max(this.lastModified, f.lastModified());
            }

            @Override
            protected boolean onDirectory(File d) {
                this.lastModified = Math.max(this.lastModified, d.lastModified());
                return true;
            }

            @Override
            public Long finish() {
                return this.lastModified;
            }
        }.go(root);
    }

    public static long lastModified(Collection<File> files) {
        long r = 0L;
        for (File f : files) {
            r = Math.max(r, f.lastModified());
        }
        return r;
    }

    public static Collection<String> deepList(File f) {
        ArrayList<String> r = new ArrayList<String>();
        for (File f2 : f.listFiles()) {
            FileUtil.deepList_(r, f2.getName(), f2);
        }
        return r;
    }

    private static void deepList_(Collection<String> r, String path, File f) {
        if (f.isDirectory()) {
            r.add(path + "/");
            for (File f2 : f.listFiles()) {
                String path2 = path + "/" + f2.getName();
                FileUtil.deepList_(r, path2, f2);
            }
        } else {
            r.add(path);
        }
    }

    public static File canonicalFile(File f) {
        try {
            if (f == null) {
                return null;
            }
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f;
        }
    }

    public static void deleteOrFail(File f) throws IOException {
        if (!f.delete()) {
            throw new IOException("Unable to delete file: " + f.getAbsolutePath());
        }
    }

    public static void deleteDirOrFail(File d) throws IOException {
        if (!FileUtil.deleteDir(d)) {
            throw new IOException("Unable to delete dir: " + d.getAbsolutePath());
        }
    }

    public static void mkdirOrFail(File d) throws IOException {
        if (!d.isDirectory() && !d.mkdirs()) {
            throw new IOException("Unable to create directories: " + d.getAbsolutePath());
        }
    }

    public static void moveOrFail(File source, File dest) throws IOException {
        if (!source.renameTo(dest)) {
            throw new IOException("Unable to move file from '" + source + "' to '" + dest + "'");
        }
    }

    public static void mergeMove(File sourceDir, File destDir) throws IOException {
        FileUtil.merge(sourceDir, destDir, true);
    }

    public static void mergeCopy(File sourceDir, File destDir) throws IOException {
        FileUtil.merge(sourceDir, destDir, false);
    }

    private static void merge(File source, File dest, boolean move) throws IOException {
        if (source.isDirectory()) {
            FileUtil.mkdirOrFail(dest);
            for (File s : source.listFiles()) {
                File d = new File(dest, s.getName());
                FileUtil.merge(s, d, move);
            }
        } else {
            if (dest.exists()) {
                FileUtil.deleteDirOrFail(dest);
            }
            if (move) {
                FileUtil.moveOrFail(source, dest);
            } else {
                FileUtil.copyFile(source, dest);
            }
        }
    }

    public static void moveDir(File sourceParent, File destParent) throws IOException {
        FileUtil.mkdirOrFail(destParent);
        for (File source : sourceParent.listFiles()) {
            File dest = new File(destParent, source.getName());
            FileUtil.moveOrFail(source, dest);
        }
    }

    @Deprecated
    public static void zipDirectories(File archive, List<File> dirs) throws IOException {
        ZipUtil.zipDirectories(archive, dirs);
    }

    @Deprecated
    public static void zipDirectories(File archive, List<File> dirs, FileFilter filter) throws IOException {
        ZipUtil.zipDirectories(archive, dirs, filter);
    }

    @Deprecated
    public static void zipDirectoryIncludeName(File archive, File dir) throws IOException {
        ZipUtil.zipDirectoryIncludeName(archive, dir);
    }

    @Deprecated
    public static void zipDirectoryIncludeName(File archive, File dir, FileFilter filter) throws IOException {
        ZipUtil.zipDirectoryIncludeName(archive, dir, filter);
    }

    @Deprecated
    public static void zipDirectory(File archive, File dir, String prefix) throws IOException {
        ZipUtil.zipDirectory(archive, dir, prefix);
    }

    @Deprecated
    public static void zipDirectory(File archive, File dir, String prefix, FileFilter filter) throws IOException {
        ZipUtil.zipDirectory(archive, dir, prefix, filter);
    }

    @Deprecated
    public static void jarDirectories(File archive, List<File> dirs) throws IOException {
        ZipUtil.jarDirectories(archive, dirs);
    }

    @Deprecated
    public static void jarDirectories(File archive, List<File> dirs, FileFilter filter) throws IOException {
        ZipUtil.jarDirectories(archive, dirs, filter);
    }

    public static interface CopyFilter {
        public boolean accept(File var1, File var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Traversal<R, E extends Exception> {
        protected boolean exit = false;

        public final void traverse(File f) throws E {
            if (this.exit) {
                return;
            }
            if (f.isDirectory()) {
                if (f.getName().startsWith(".")) {
                    return;
                }
                boolean cont = this.onDirectory(f);
                if (cont) {
                    File[] childs;
                    for (File child : childs = f.listFiles()) {
                        this.traverse(child);
                    }
                }
            } else {
                this.onFile(f);
            }
        }

        protected boolean onDirectory(File d) throws E {
            return true;
        }

        protected void onFile(File f) throws E {
        }

        public R go(File f) throws E {
            if (f.exists()) {
                this.traverse(f);
            }
            return this.finish();
        }

        public R finish() {
            return null;
        }
    }
}

