/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import ebuild.util.IOUtil;
import ebuild.util.JSONUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.json.simple.parser.ParseException;

public class HttpUtil {
    public static final GetListener IGNORE = new GetListener(){

        public void contentLength(int length) {
        }

        public void progress(int progress) {
        }
    };

    public static Object getJson(String url) throws IOException {
        URL u = new URL(url);
        HttpURLConnection httpConnection = (HttpURLConnection)u.openConnection();
        int code = httpConnection.getResponseCode();
        InputStream is = httpConnection.getInputStream();
        InputStreamReader r = new InputStreamReader(is);
        try {
            return JSONUtil.readObject(r);
        }
        catch (ParseException e) {
            throw new IOException("Invalid json from:\nurl: " + url + "content-type: " + httpConnection.getContentType() + "code" + code);
        }
    }

    public static String getString(String url) throws IOException {
        URL u = new URL(url);
        InputStream is = u.openStream();
        InputStreamReader r = new InputStreamReader(is);
        return IOUtil.readerToString(r);
    }

    public static void get(String url, File out) throws IOException {
        HttpUtil.get(url, new FileOutputStream(out), IGNORE);
    }

    public static void get(String url, OutputStream out) throws IOException {
        HttpUtil.get(url, out, IGNORE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void get(String url, OutputStream out, GetListener listener) throws IOException {
        URL u = new URL(url);
        URLConnection conn = u.openConnection();
        listener.contentLength(conn.getContentLength());
        InputStream in = conn.getInputStream();
        try {
            IOUtil.pipe(in, out, 16384, listener);
        }
        finally {
            in.close();
        }
    }

    public static interface GetListener
    extends IOUtil.ProgressListener {
        public void contentLength(int var1);
    }
}

