/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import ebuild.util.StringUtil;
import java.util.ArrayList;

public class PathUtil {
    public static String removeLastElement(String path) {
        int index = path.lastIndexOf("/", path.length() - 1);
        if (index == -1) {
            return null;
        }
        return path.substring(0, index + 1);
    }

    public static String canonicalisePath(String path) {
        if (null == path) {
            return null;
        }
        if ("".equals(path)) {
            return "";
        }
        boolean absolute = path.charAt(0) == '/';
        String[] ss = path.split("/");
        int up = 0;
        ArrayList<String> down = new ArrayList<String>(ss.length);
        for (String s : ss) {
            if ("".equals(s) || ".".equals(s)) continue;
            if ("..".equals(s)) {
                if (down.size() > 0) {
                    down.remove(down.size() - 1);
                    continue;
                }
                ++up;
                continue;
            }
            down.add(s);
        }
        if (absolute && up > 0) {
            throw new RuntimeException("Illegal path: " + path);
        }
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < up; ++i) {
            r.append("../");
        }
        if (absolute) {
            r.append("/");
        }
        r.append(StringUtil.join("/", down));
        return r.toString();
    }
}

