package ebuild.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

import org.json.simple.parser.ParseException;

import ebuild.util.IOUtil.ProgressListener;

public class HttpUtil {

	static final public GetListener IGNORE = new GetListener(){
		public void contentLength(int length) {}
		public void progress(int progress) {}
	};

	public interface GetListener extends ProgressListener{
		public void contentLength(int length);
	}	
	
	static public Object getJson(String url) throws IOException {
		URL u = new URL(url);
		HttpURLConnection httpConnection = (HttpURLConnection)u.openConnection();
		int code = httpConnection.getResponseCode();
		InputStream is = httpConnection.getInputStream();
		Reader r = new InputStreamReader(is);
		try {
			return JSONUtil.readObject(r);
		} catch (ParseException e) {
			 throw new IOException(
			     "Invalid json from:\n" +
			     "url: "+url+
			     "content-type: "+httpConnection.getContentType()+
			     "code"+code);
		}
	}
	
	static public String getString(String url) throws IOException {
		URL u = new URL(url);
		InputStream is = u.openStream();
		Reader r = new InputStreamReader(is);
		return IOUtil.readerToString(r);
	}
	
	static public void get(String url, File out) throws IOException {
		get(url, new FileOutputStream(out), IGNORE);
	}
	
	static public void get(String url, OutputStream out) throws IOException {
		get(url, out, IGNORE);
	}
	
	static public void get(String url, OutputStream out, GetListener listener) throws IOException {
		URL u = new URL(url);
		URLConnection conn = u.openConnection();
	    listener.contentLength(conn.getContentLength());
		InputStream in = conn.getInputStream();
		try{
			IOUtil.pipe(in, out, 16*1024, listener);
		}finally{
			in.close();
		}
	}
}
