package ebuild.util.tuple;

import static ebuild.util.ObjectUtil.*;

public class Triple<A,B,C> {
    final public A a;
    final public B b;
    final public C c;
    
    public Triple(A a, B b, C c){
        this.a = a;
        this.b = b;
        this.c = c;
    }
    
    public String toString()  { 
        return "(" + asString(a) + ", " + asString(b) + ", " + asString(c) + ")"; 
    }
    
    public int hashCode() {
        return hashOf(a)+hashOf(b)+hashOf(c);
    }

    public boolean equals(Object o) {
        if(o instanceof Triple){
            Triple b = (Triple)o;
            return areEqual(this.a, b.a) && areEqual(this.b, b.b) && areEqual(this.c, b.c); 
        }
        return false;
    }

}
