package ebuild.util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
	static final public Object[] EMPTYARRAY = new Object[0];
	static final public List EMPTY_LIST  = Collections.EMPTY_LIST;
	static final public Set EMPTY_SET = Collections.EMPTY_SET;
	static final public Map EMPTY_MAP = Collections.EMPTY_MAP;
	static final public Iterator EMPTY_ITERATOR = EMPTY_SET.iterator();
	
	static public <V>Iterator<V> singletonIterator(V obj){
		return singletonSet(obj).iterator();
	}
	static public <V>List<V> singletonList(V obj){
		return Collections.singletonList(obj); 
	}
	static public <K,V>Map<K,V> singletonMap(K k,V v){
		return Collections.singletonMap(k, v);
	}
	static public <V>Set<V> singletonSet(V obj){
		return Collections.singleton(obj);
	}
	static public <V>Iterator<V> arrayIterator(V[] types) {
		return Arrays.asList(types).iterator();
	}
	static public<V> Set<V> newSet(V... vs) {
        Set<V> r = new HashSet(vs.length);
	    for(V v: vs) r.add(v);
        return r;
    }
	static public<V> Set<V> newOrderedSet(V... vs) {
        Set<V> r = new LinkedHashSet(vs.length);
	    for(V v: vs) r.add(v);
        return r;
    }
	static public<V> List<V> newImmutableList(V... vs) {
		if(vs.length==0) return CollectionUtil.EMPTY_LIST;
		if(vs.length==1) return singletonList(vs[0]);
		return newList(vs);
	}
	static public<V> List<V> newList(V... vs) {
	    List<V> r = new ArrayList(vs.length);
	    for(V v: vs) r.add(v);
	    return r;
	}
	static public<O> void filter(Collection<O> col, Filter<O> f){
	    Iterator<O> I = col.iterator();
	    while(I.hasNext()){
	        O o = I.next();
	        if(!f.accept(o)) I.remove();
	    }
	}
	static public Filter ACCEPT_ALL = new Filter(){public boolean accept(Object object) { return true; }};
	static public interface Filter<O>{
	    public boolean accept(O object);
	}
    public static Map newMap(Object... args) {
        if(args.length % 2!=0) throw new RuntimeException("!");
        Map r = new HashMap(args.length);
        for(int i=0; i<args.length; i+=2){
            r.put(args[i], args[i+1]);
        }
        return r;
    }
    static public <X>Iterable<X> concat(final Iterable<X>... iterables) {
    
    	return new Iterable<X>(){
			public Iterator<X> iterator() {
				final Iterator<X>[] iterators = new Iterator[iterables.length];
				for(int i=0; i<iterables.length; i++){
					iterators[i] = iterables[i].iterator();
				};
				
				
				return new Iterator<X>(){
					int current = 0;
					
					public boolean hasNext() {
						for(int i=current; i<iterators.length; i++)
							if(iterators[i].hasNext()) return true;
						return false;
					}
					
					public X next() { 
						Iterator<X> I = iterators[current];
						while(!I.hasNext()){
							int n = current + 1;
							if(n<iterators.length) {
								I = iterators[n];
								current = n;
							}else{
								break;
							}
						}
						return I.next();
					}
					
					public void remove() { throw new Error("!"); }
				};
			}
			
		};
	}
    
}
