package ebuild.util;

import java.util.ArrayList;
import java.util.List;

public class PathUtil {
	static public String removeLastElement(String path){
		int index = path.lastIndexOf("/", path.length()-1);
		if(index==-1) return null;
		return path.substring(0, index+1);
	}
	static public String canonicalisePath(String path){
		if(null == path) return null;
		if("".equals(path)) return "";
		boolean absolute = path.charAt(0)=='/';
		
		String[] ss = path.split("/");
		int up = 0;
		List<String> down = new ArrayList(ss.length);
		for(String s: ss){
			if("".equals(s)) continue;
			if(".".equals(s)) continue;
			if("..".equals(s)){
				if(down.size()>0) down.remove(down.size()-1);
				else up++;
			}else{
				down.add(s);
			}
		}
		
		if(absolute && up>0) throw new RuntimeException("Illegal path: "+path);
		
		StringBuilder r = new StringBuilder();
		for(int i=0; i<up; i++) r.append("../");
		if(absolute) r.append("/");
		r.append(StringUtil.join("/", down));
		return r.toString();
	}
}
