package ebuild.util.tuple;

import static ebuild.util.ObjectUtil.*;

public class Pair<A,B> {
    final public A a;
    final public B b;
    
    public Pair(A a, B b){
        this.a = a;
        this.b = b;
    }
    
    public String toString()  { 
        return "(" + asString(a) + ", " + asString(b) + ")"; 
    }
    
    public int hashCode() {
        return hashOf(a)+hashOf(b);
    }

    public boolean equals(Object o) {
        if(o instanceof Pair){
            Pair b = (Pair)o;
            return areEqual(this.a, b.a) && areEqual(this.b, b.b);
        }
        return false;
    }

}
