package ebuild.repo.ivy;

import java.net.URL;

import ebuild.api.log.ILogger;
import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.api.repo.IRepository;
import ebuild.api.repo.RepositoryPluginException;

public class IvyProvider extends AbstractRepositoryProvider{

	private ILogger logger;
	public void initLogger(ILogger logger){ this.logger = logger; } 
	
	@Override
	public IRepository getRepository(String repositoryUri) throws RepositoryPluginException {
		if("named://ivy-roundup".equals(repositoryUri)){
			return new IvyRepository(logger, repositoryUri, "ivy", getIvyRoundUpSettings());
		}
		throw new RepositoryPluginException("Invalid ivy repository uri: "+repositoryUri);
	}	
	
	
	static public URL getIvyRoundUpSettings(){
        return IvyProvider.class.getResource("ivysettings-ivyroundup.xml");
	}
	
}