/*
 * Decompiled with CFR 0.152.
 */
package ebuild.ivy;

import ebuild.api.log.ILogger;
import ebuild.util.StringUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.util.AbstractMessageLogger;
import org.apache.ivy.util.MessageLogger;
import org.apache.ivy.util.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyStuff {
    public static void parseDepConfs(DefaultModuleDescriptor md, String confExpression, DefaultDependencyDescriptor dd) throws Exception {
        new ParserForConf(md).parseDepsConfs(confExpression, dd);
    }

    public static AbstractMessageLogger newIvyLogger(final ILogger logger, boolean verbose) {
        if (verbose) {
            return new AbstractMessageLogger(){

                public void rawlog(String msg, int level) {
                    logger.log(msg);
                }

                public void log(String msg, int level) {
                    logger.log(msg);
                }

                protected void doProgress() {
                    logger.logPartial(".");
                }

                protected void doEndProgress(String s) {
                    logger.logPartial("\n");
                }
            };
        }
        return new AbstractMessageLogger(){

            public void rawlog(String msg, int level) {
                if (level <= 0) {
                    logger.log(msg);
                }
            }

            public void log(String msg, int level) {
                if (level <= 0) {
                    logger.log(msg);
                } else if (msg.startsWith("downloading")) {
                    logger.log(msg);
                }
            }

            protected void doProgress() {
                logger.logPartial(".");
            }

            protected void doEndProgress(String s) {
                logger.logPartial("\n");
            }
        };
    }

    private static String ivyMapping(String master, Collection<String> confs) {
        return String.valueOf(master) + "->" + StringUtil.join((String)",", confs);
    }

    private static void addSuperConfs(ModuleDescriptor md, Set<String> confset, String conf) throws Exception {
        String[] extended;
        confset.add(conf);
        Configuration confObj = md.getConfiguration(conf);
        String[] stringArray = extended = confObj.getExtends();
        int n = extended.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            IvyStuff.addSuperConfs(md, confset, s);
            ++n2;
        }
    }

    public static String[] getIvyConfList(ModuleDescriptor md, String ivyconf) throws Exception {
        LinkedHashSet<String> confs = new LinkedHashSet<String>(3);
        IvyStuff.addSuperConfs(md, confs, ivyconf);
        return confs.toArray(new String[confs.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IvyFetcher {
        final Ivy ivy;
        final ILogger logger;

        public IvyFetcher(URL settingsFile, ILogger logger, AbstractMessageLogger ivyLogger) throws Exception {
            IvySettings settings = new IvySettings();
            this.logger = logger;
            this.ivy = Ivy.newInstance((IvySettings)settings);
            this.ivy.getLoggerEngine().pushLogger((MessageLogger)ivyLogger);
            if (settingsFile != null) {
                this.ivy.configure(settingsFile);
            } else {
                this.ivy.configureDefault();
            }
            File cache = new File(settings.substitute(settings.getDefaultCache().getAbsolutePath()));
            if (!cache.exists()) {
                cache.mkdirs();
            } else if (!cache.isDirectory()) {
                throw new Error(cache + " is not a directory");
            }
        }

        public Collection<File> fetchIvyLibrary(File lib, String org, String module, String version, Collection<String> confs) throws Exception {
            IvyContext.getContext().setIvy(this.ivy);
            DefaultModuleDescriptor md = DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)ModuleRevisionId.newInstance((String)"dummy", (String)"dummy", (String)"working"));
            md.addConfiguration(new Configuration("main", Configuration.Visibility.PUBLIC, null, null, true, null));
            DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor((ModuleDescriptor)md, ModuleRevisionId.newInstance((String)org, (String)module, (String)version), false, false, true);
            String ivyMapping = IvyStuff.ivyMapping("main", confs);
            ParserForConf parser = new ParserForConf(md);
            parser.parseDepsConfs(ivyMapping, dd);
            md.addDependency((DependencyDescriptor)dd);
            return this.fetchDependencies(lib, (ModuleDescriptor)md, "main");
        }

        private Collection<File> fetchDependencies(File lib, ModuleDescriptor md, String conf) throws Exception {
            String[] confs = IvyStuff.getIvyConfList(md, conf);
            ResolveOptions resolveOptions = new ResolveOptions().setConfs(confs);
            ResolveReport report = this.ivy.resolve(md, resolveOptions);
            for (String s : report.getAllProblemMessages()) {
                this.logger.log(s);
            }
            ArtifactDownloadReport[] artifactDownloadReportArray = report.getAllArtifactsReports();
            int n = artifactDownloadReportArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArtifactDownloadReport ar = artifactDownloadReportArray[n2];
                DownloadStatus status = ar.getDownloadStatus();
                Artifact artifact = ar.getArtifact();
                ModuleRevisionId artifactRev = artifact.getModuleRevisionId();
                String artifactName = String.valueOf(artifactRev.getName()) + "-" + artifactRev.getRevision() + "." + artifact.getExt();
                if (DownloadStatus.FAILED == status) {
                    this.logger.log("artifact failed to download   : " + artifactName);
                    throw new Exception(ar.getDownloadDetails());
                }
                if (DownloadStatus.NO == status) {
                    this.logger.log("artifact found in cache       : " + artifactName);
                } else if (DownloadStatus.SUCCESSFUL == status) {
                    this.logger.log("artifact downloaded and cached: " + artifactName);
                } else {
                    throw new Error();
                }
                ++n2;
            }
            RetrieveOptions options = new RetrieveOptions();
            options.setArtifactFilter(new Filter(){

                public boolean accept(Object o) {
                    if (o instanceof Artifact) {
                        Artifact a = (Artifact)o;
                        return "jar".equals(a.getExt());
                    }
                    return true;
                }
            }).setConfs(confs);
            this.ivy.retrieve(md.getModuleRevisionId(), String.valueOf(lib.getCanonicalPath()) + "/[artifact]-[revision].[ext]", options);
            List artifacts = report.getArtifacts();
            ArrayList<File> artifactFiles = new ArrayList<File>(artifacts.size());
            for (Artifact a : artifacts) {
                artifactFiles.add(new File(lib, String.valueOf(a.getName()) + "-" + a.getModuleRevisionId().getRevision() + "." + a.getExt()));
            }
            return artifactFiles;
        }
    }

    public static class ParserForConf
    extends XmlModuleDescriptorParser.Parser {
        public ParserForConf(DefaultModuleDescriptor md) throws Exception {
            super(null, null);
            this.setMd(md);
        }

        public void parseDepsConfs(String confs, DefaultDependencyDescriptor dd) {
            super.parseDepsConfs(confs, dd);
        }
    }
}

