package ebuild.ivy;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.Configuration.Visibility;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.util.AbstractMessageLogger;
import org.apache.ivy.util.Message;

import ebuild.api.log.ILogger;
import ebuild.util.StringUtil;


public class IvyStuff {
	static public class ParserForConf extends XmlModuleDescriptorParser.Parser{

		public ParserForConf(DefaultModuleDescriptor md) throws Exception {
			super(null, null);
			setMd(md);
		}
		// expose this method
		public void parseDepsConfs(String confs, DefaultDependencyDescriptor dd) {
			super.parseDepsConfs(confs, dd);
		}
	}

	static public void parseDepConfs(DefaultModuleDescriptor md, String confExpression, DefaultDependencyDescriptor dd) throws Exception {
		new ParserForConf(md).parseDepsConfs(confExpression, dd);
	}

	
	static public class IvyFetcher{
	    final Ivy ivy;
	    final ILogger logger;
	    public IvyFetcher(URL settingsFile, final ILogger logger) throws Exception{
	        IvySettings settings = new IvySettings();
	        this.logger = logger;
	        ivy = Ivy.newInstance(settings);
            ivy.getLoggerEngine().pushLogger(new AbstractMessageLogger(){
                public void rawlog(String msg, int level) {
                    if(level<=Message.MSG_ERR){
                        logger.log(msg);
                    }
                }
                public void log(String msg, int level) {
                    if(level<=Message.MSG_ERR){
                        logger.log(msg);
                    }else if(msg.startsWith("downloading")){
                        logger.log(msg);
                    }
                }
                protected void doProgress() {
                    logger.logPartial(".");
                }
                protected void doEndProgress(String s) {
                    logger.logPartial("\n");
                }});
            if(settingsFile!=null){
                //ivy.configure(new File("ivysettings.xml"));// settingsFile);
                ivy.configure(settingsFile);
            }else{
                ivy.configureDefault();
            }
            
            
            File cache = new File(settings.substitute(settings
                    .getDefaultCache().getAbsolutePath()));
            
            if (!cache.exists()) {
                cache.mkdirs();
            } else if (!cache.isDirectory()) {
                throw new Error(cache + " is not a directory");
            }
	    }
	    
	    public Collection<File> fetchIvyLibrary(File lib, String org, String module, String version, Collection<String> confs) throws Exception{
	        // REMARK - yes, sadly this is the simplest way to do this with ivy
	        IvyContext.getContext().setIvy(ivy);
	        
	        // specify a dummy project with a single dependency and a single configuration
	        DefaultModuleDescriptor md =    DefaultModuleDescriptor.newDefaultInstance(
	            ModuleRevisionId.newInstance("dummy", "dummy", "working")
	        );
	        md.addConfiguration(new Configuration("main", Visibility.PUBLIC,null, null,                  true, null));
	        
	        DefaultDependencyDescriptor dd =
	            new DefaultDependencyDescriptor(md,
	                ModuleRevisionId.newInstance(org,
	                                             module,
	                                             version),
	                                            false,
	                                            false,
	                                            true);
	        
	        String ivyMapping = ivyMapping("main",confs);
	        ParserForConf parser = new ParserForConf(md);
	        parser.parseDepsConfs(ivyMapping, dd);
	        md.addDependency(dd);
	        return fetchDependencies(lib, md, "main");
	    }
	    
	    private Collection<File> fetchDependencies(File lib, ModuleDescriptor md, String conf) throws Exception {
	        String[] confs = getIvyConfList(md, conf);

	        ResolveOptions resolveOptions = new ResolveOptions().setConfs(confs);
	        //ivy.retrieve(mrid, destFilePattern, options)
	        ResolveReport report = ivy.resolve(md, resolveOptions);
	        for(String s: (List<String>)report.getAllProblemMessages()){
	            logger.log(s);
	        }
	        
	        for(ArtifactDownloadReport ar: report.getAllArtifactsReports()){
	            DownloadStatus status = ar.getDownloadStatus();
	            Artifact artifact = ar.getArtifact();
	            ModuleRevisionId artifactRev = artifact.getModuleRevisionId();
	            String artifactName = artifactRev.getName()+"-"+artifactRev.getRevision()+"."+artifact.getExt();
	            if(DownloadStatus.FAILED==status){
	                logger.log("artifact failed to download   : "+artifactName);
	                throw new Exception(ar.getDownloadDetails());
	            }else if(DownloadStatus.NO==status){
	                logger.log("artifact found in cache       : "+artifactName);
	            }else if(DownloadStatus.SUCCESSFUL==status){
	                logger.log("artifact downloaded and cached: "+artifactName);
	                
	            }else{
	                throw new Error();
	            }
	        }
	        ivy.retrieve(md.getModuleRevisionId(), 
	                lib.getCanonicalPath()+"/[artifact]-[revision].[ext]", new RetrieveOptions().setConfs(confs));
	        
	        List<Artifact> artifacts = report.getArtifacts();
	        List<File> artifactFiles = new ArrayList(artifacts.size());
	        for(Artifact a: artifacts){
	            artifactFiles.add(new File(lib,a.getName()+"-"+a.getModuleRevisionId().getRevision()+"."+a.getExt()));
	        }
	        return artifactFiles;
	    }
	    
	    
	}
	
	static private String ivyMapping(String master, Collection<String> confs){
	    return master+"->"+StringUtil.join(",", confs);
	}

	
	static private void addSuperConfs(ModuleDescriptor md, Set<String> confset, String conf) throws Exception{
		confset.add(conf);
		Configuration confObj = md.getConfiguration(conf);
		String[] extended = confObj.getExtends();
		 for(String s: extended){
			addSuperConfs(md, confset, s);
		}
	}
	
	static public String[] getIvyConfList(ModuleDescriptor md, String ivyconf) throws Exception {
		Set<String> confs = new LinkedHashSet<String>(3);
		addSuperConfs(md, confs, ivyconf);
		return confs.toArray(new String[confs.size()]);
	}
	
}
