/*
 * Decompiled with CFR 0.152.
 */
package ebuild.repo.maven;

import ebuild.api.common.IConfiguration;
import ebuild.api.common.IElementKey;
import ebuild.api.log.ILogger;
import ebuild.api.repo.AbstractReleaseRepository;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.ivy.IvyStuff;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenRepository
extends AbstractReleaseRepository {
    private final String uri;
    private final String universe;
    final IvyStuff.IvyFetcher fetcher;
    public static String METAXML = "<ebuild-module ebuild-version=\"pre-1.0\">\n   <dependencies/>\n</ebuild-module>\n";

    public MavenRepository(ILogger logger, String uri, String universe, URL settingsFile) {
        this.uri = uri;
        this.universe = universe;
        try {
            this.fetcher = new IvyStuff.IvyFetcher(settingsFile, logger);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public String getLastChangeRevision(IElementKey key) {
        return key.getVersion().getRevision();
    }

    public String getUniverse() {
        return this.universe;
    }

    public String getUri() {
        return this.uri;
    }

    public void fetchComponentRelease(File releaseDir, IElementKey key, String releaseFileName) {
        throw new Error("Unsupported operation");
    }

    public void fetchMeta(File metaDir, IElementKey key) {
        try {
            metaDir.mkdirs();
            IOUtil.stringToFile((String)METAXML, (File)new File(metaDir, "module.xml"));
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public void fetchModuleRelease(File artifactDir, IElementKey key, IConfiguration conf) throws RepositoryPluginException {
        File javaDir = new File(artifactDir, "java.classes.jar.group");
        try {
            this.fetcher.fetchIvyLibrary(javaDir, key.getOrg(), key.getName(), key.getVersion().getTag(), this.getIvyConfs(conf));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    protected Collection<String> getIvyConfs(IConfiguration conf) {
        return CollectionUtil.newSet((Object[])new String[]{"default"});
    }

    public FileFilter getFileFilter() {
        return FileUtil.FILEFILTER_ALL;
    }
}

