package ebuild.repo.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;

import ebuild.api.common.IConfiguration;
import ebuild.api.common.IElementKey;
import ebuild.api.log.ILogger;
import ebuild.api.repo.AbstractReleaseRepository;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.ivy.IvyStuff;
import ebuild.ivy.IvyStuff.IvyFetcher;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;

public class MavenRepository extends AbstractReleaseRepository{
	
	final private String uri;
	final private String universe;
	final IvyFetcher fetcher;
    
	public MavenRepository(final ILogger logger, String uri, String universe, URL settingsFile){
		this.uri = uri;
		this.universe = universe;
        try {
        	boolean verbose = "true".equals(System.getProperty("ebuild.verbosity.two"));
            fetcher = new IvyFetcher(settingsFile, logger, IvyStuff.newIvyLogger(logger, verbose));
        } catch (Exception e) {
            throw new Error(e);
        }
	}	
	
	public String getLastChangeRevision(IElementKey key) { return key.getVersion().getRevision(); }
	public String getUniverse() { return universe; }
	public String getUri() { return uri; }
	
	
	static public String METAXML = 
		"<ebuild-module ebuild-version=\"0.8\">\n"+
		"   <artifact name=\"java_classes.jar\"/>\n"+
		"   <dependencies/>\n"+
		"</ebuild-module>\n";

	
	public void fetchComponentRelease(File releaseDir, IElementKey key, String releaseFileName) { throw new Error("Unsupported operation"); }
	public void fetchMeta(File metaDir, IElementKey key) { 
		try {
			metaDir.mkdirs();
			IOUtil.stringToFile(METAXML, new File(metaDir, "module.xml"));
		} catch (IOException e) {
			throw new Error(e);
		}
	}

	public void fetchModuleRelease(File destDir, IElementKey key, IConfiguration conf, String artifact) throws RepositoryPluginException {
		if(!"java_classes.jar".equals(artifact)) 
			throw new RepositoryPluginException("Maven repository plugin only supports fetching of 'java_classes.jar' artifacts, call requested '"+artifact+"'");
		File javaDir = new File(destDir, "java_classes.jar.group");
        try {
            fetcher.fetchIvyLibrary(javaDir, key.getOrg(), key.getName(), key.getVersion().getTag(), getIvyConfs(conf));
        } catch (Exception e) {
            throw new Error(e);
        }
 	}

	
	protected Collection<String> getIvyConfs(IConfiguration conf){
		return CollectionUtil.newSet("default");
	}
	
	public FileFilter getFileFilter() { return FileUtil.FILEFILTER_ALL; }
	


}
