package ebuild.repo.svn;

import static ebuild.util.JSONUtil.readObject;

import java.io.File;
import java.io.FileReader;
import java.util.Map;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

import ebuild.util.CollectionUtil;


public class SvnLoginStore {
    final private Map<String,String> values; 
    public SvnLoginStore(File logins) {
        try {
        	if(logins.isFile()){
                values = (Map)readObject(new FileReader(logins));
        	}else{
        		values = CollectionUtil.EMPTY_MAP;
        	}
        } catch (Exception e) {
            throw new Error("Could not read file: "+logins,e);
        }
    }
    
    public Login getLogin(String url) {
        String u_p = values.get(url);
        if(u_p!=null){
            return new Login(u_p);
        }
        return null;
    }
    
    public Login getLogin(SVNURL url) throws SVNException{
        SVNURL last = null;
        while(!url.equals(last)){
            String s = url.toString();
            String u_p = values.get(s);
            if(u_p!=null){
                return new Login(u_p);
            }
            last = url;
            url = url.removePathTail();
        }
        return null;  
    }

}
