/*
 * Decompiled with CFR 0.152.
 */
package ebuild.repo.svn;

import ebuild.api.log.ILogger;
import ebuild.util.StringUtil;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnStatusChecker
implements ISVNStatusHandler {
    final boolean remote;
    final ILogger logger;
    private boolean working = false;
    private long minRevision = -1L;
    private long maxRevision = Long.MAX_VALUE;

    public SvnStatusChecker(boolean remote, ILogger logger) {
        this.remote = remote;
        this.logger = logger;
    }

    public boolean isWorking() {
        return this.working;
    }

    public long getMinRevision() {
        return this.minRevision;
    }

    public long getMaxRevision() {
        return this.maxRevision;
    }

    public void handleStatus(SVNStatus status) {
        SVNStatusType contentsStatus = status.getContentsStatus();
        if (contentsStatus == SVNStatusType.STATUS_IGNORED) {
            return;
        }
        char pathChangeType = contentsStatus.getCode();
        boolean isAddedWithHistory = status.isCopied();
        if (contentsStatus != SVNStatusType.STATUS_NORMAL) {
            this.working = true;
        }
        String remoteChangeType = " ";
        if (status.getRemotePropertiesStatus() != SVNStatusType.STATUS_NONE || status.getRemoteContentsStatus() != SVNStatusType.STATUS_NONE) {
            remoteChangeType = "*";
        }
        SVNStatusType propertiesStatus = status.getPropertiesStatus();
        String propertiesChangeType = String.valueOf(propertiesStatus.getCode());
        boolean isLocked = status.isLocked();
        boolean isSwitched = status.isSwitched();
        SVNLock localLock = status.getLocalLock();
        SVNLock remoteLock = status.getRemoteLock();
        String lockLabel = " ";
        if (localLock != null) {
            lockLabel = "K";
            if (remoteLock != null) {
                if (!remoteLock.getID().equals(localLock.getID())) {
                    lockLabel = "T";
                }
            } else if (this.remote) {
                lockLabel = "B";
            }
        } else if (remoteLock != null) {
            lockLabel = "O";
        }
        long baseRevision = this.getRevision(status.getRevision());
        long committedRevision = this.getRevision(status.getCommittedRevision());
        long remoteRevision = this.getRevision(status.getRemoteRevision());
        this.minRevision = Math.max(committedRevision, this.minRevision);
        this.maxRevision = Math.min(remoteRevision - 1L, this.maxRevision);
        this.logger.log(String.valueOf(pathChangeType) + propertiesChangeType + (isLocked ? "L" : " ") + (isAddedWithHistory ? "+" : " ") + (isSwitched ? "S" : " ") + lockLabel + "  " + pathChangeType + "  " + remoteChangeType + "  " + StringUtil.lpad((int)10, (String)("b: " + baseRevision)) + "  " + StringUtil.lpad((int)10, (String)("c: " + committedRevision)) + "  " + StringUtil.lpad((int)10, (String)("r: " + remoteRevision)) + "  " + StringUtil.rpad((int)10, (String)(status.getAuthor() != null ? status.getAuthor() : "?")) + "  " + status.getFile().getPath());
    }

    private long getRevision(SVNRevision r) {
        if (r == null) {
            return -1L;
        }
        return r.getNumber();
    }
}

