/*
 * Decompiled with CFR 0.152.
 */
package ebuild.repo.svn;

import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.repo.svn.Login;
import ebuild.repo.svn.SvnLoginStore;
import ebuild.repo.svn.SvnRepository;
import ebuild.repo.svn.SvnWorkingDir;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnProvider
extends AbstractRepositoryProvider {
    private final SVNClientManager clientManager = SVNClientManager.newInstance();
    private SvnLoginStore logins;
    private Map<String, SvnRepository> repos = new HashMap<String, SvnRepository>();

    public SvnProvider() {
        SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new ISVNAdminAreaFactorySelector(){

            public Collection getEnabledFactories(File path, Collection factories, boolean writeAccess) throws SVNException {
                TreeSet<SVNAdminAreaFactory> enabledFactories = new TreeSet<SVNAdminAreaFactory>();
                for (SVNAdminAreaFactory factory : factories) {
                    int version = factory.getSupportedVersion();
                    switch (version) {
                        case 4: 
                        case 8: 
                        case 9: 
                        case 10: {
                            enabledFactories.add(factory);
                        }
                    }
                }
                return enabledFactories;
            }
        });
    }

    public void initCredentials(File credentialsFile) {
        this.logins = new SvnLoginStore(credentialsFile);
    }

    public SvnRepository getRepository(String ebuildRoot) throws RepositoryPluginException {
        SvnRepository r = this.repos.get(ebuildRoot);
        if (r == null) {
            try {
                Login login = this.logins.getLogin(ebuildRoot);
                r = this.newRepository(ebuildRoot, login);
            }
            catch (SVNException e) {
                throw new RepositoryPluginException((Throwable)e);
            }
        }
        return r;
    }

    private String getEBuildRootForWC(SVNInfo info) {
        String root = info.getRepositoryRootURL().toString();
        String complete = info.getURL().toString();
        String path = complete.substring(root.length());
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        int i = 0;
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ("trunk".equals(s) || "branches".equals(s)) break;
            root = String.valueOf(root) + "/" + s;
            ++i;
            ++n2;
        }
        return root;
    }

    public SvnWorkingDir getWorkingCopy(File dir) throws RepositoryPluginException {
        if (!new File(dir, ".svn").isDirectory()) {
            return null;
        }
        try {
            SVNInfo info = this.clientManager.getWCClient().doInfo(dir, SVNRevision.WORKING);
            String root = this.getEBuildRootForWC(info);
            SvnRepository repo = this.getRepository(root);
            return new SvnWorkingDir(repo, dir);
        }
        catch (SVNException e) {
            throw new RepositoryPluginException((Throwable)e);
        }
    }

    public SvnRepository newRepository(String ebuildRoot, Login login) throws RepositoryPluginException {
        try {
            SVNURL ebuildRootUrl = SVNURL.parseURIEncoded((String)ebuildRoot);
            String protocol = ebuildRootUrl.getProtocol();
            if ("svn".equals(protocol) || "svn+ssh".equals(protocol)) {
                SVNRepositoryFactoryImpl.setup();
            } else if ("http".equals(protocol) || "https".equals(protocol)) {
                DAVRepositoryFactory.setup();
            } else if ("file".equals(protocol)) {
                FSRepositoryFactory.setup();
            } else {
                throw new RepositoryPluginException("Not a supported svn protocol: " + protocol);
            }
            SvnRepository r = new SvnRepository(ebuildRootUrl, login);
            this.repos.put(ebuildRoot, r);
            return r;
        }
        catch (SVNException e) {
            throw new RepositoryPluginException((Throwable)e);
        }
    }
}

