/*
 * Decompiled with CFR 0.152.
 */
package ebuild.repo.svn;

import ebuild.api.repo.AbstractWorkingCopy;
import ebuild.repo.svn.SvnRepository;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNWCClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnWorkingDir
extends AbstractWorkingCopy {
    final SvnRepository repo;
    final File dir;

    public SvnWorkingDir(SvnRepository repo, File dir) {
        this.repo = repo;
        this.dir = dir;
    }

    public SvnRepository getRepository() {
        return this.repo;
    }

    public void addIgnores(Collection<String> ignores) {
        try {
            String val = this.readLocalProperty(this.dir, "svn:ignore", "");
            String val2 = this.appendIgnores(val, ignores);
            if (!val2.equals(val)) {
                SVNWCClient client = this.repo.clientManager.getWCClient();
                client.doSetProperty(this.dir, "svn:ignore", SVNPropertyValue.create((String)val2), false, SVNDepth.EMPTY, null, null);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public String getBranch() {
        try {
            String rootUri = this.getRepository().getUri();
            SVNStatus status = this.repo.clientManager.getStatusClient().doStatus(this.dir, false);
            String dirUri = status.getURL().toString();
            String path = dirUri.substring(rootUri.length());
            if (path.startsWith("/branches/")) {
                String[] segments = path.substring(1).split("/");
                String branch = segments[1];
                return branch;
            }
            return null;
        }
        catch (SVNException e) {
            throw new Error(e);
        }
    }

    private String appendIgnores(String value, Collection<String> ignores) {
        String[] vs;
        HashSet<String> add = new HashSet<String>(ignores);
        String[] stringArray = vs = value.split("\n");
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            add.remove(v);
            ++n2;
        }
        String r = value;
        for (String s : add) {
            r = String.valueOf(r) + "\n" + s + "\n";
        }
        return r;
    }

    private String readLocalProperty(File dir, String name, String default_) throws SVNException {
        final SVNPropertyValue[] r = new SVNPropertyValue[1];
        SVNWCClient client = this.repo.clientManager.getWCClient();
        client.doGetProperty(dir, name, SVNRevision.WORKING, SVNRevision.WORKING, SVNDepth.EMPTY, new ISVNPropertyHandler(){

            public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
            }

            public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
            }

            public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                r[0] = property.getValue();
            }
        }, null);
        return r[0] == null ? "" : r[0].toString();
    }

    public String toString() {
        return (Object)((Object)this.repo) + " ";
    }
}

