/*
 * Decompiled with CFR 0.152.
 */
package ebuild.repo.svn;

import ebuild.api.common.IElementKey;
import ebuild.api.common.IVersion;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.repo.svn.Login;
import ebuild.util.FileUtil;
import ebuild.util.ReturnRef;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnRepository
extends AbstractSourceRepository {
    public final SVNURL repoRoot;
    public final SVNURL ebuildRoot;
    public final SVNClientManager clientManager;

    public SvnRepository(SVNURL repoRoot, SVNURL ebuildRoot, Login login) throws SVNException {
        this.repoRoot = repoRoot;
        this.ebuildRoot = ebuildRoot;
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        this.clientManager = login != null ? SVNClientManager.newInstance((DefaultSVNOptions)options, (String)login.username, (String)login.password) : SVNClientManager.newInstance((ISVNOptions)options);
    }

    public String toString() {
        return "svn / " + this.ebuildRoot;
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File f) {
                return !".svn".equals(f.getName());
            }
        };
    }

    public int compareRevisions(String oa, String ob) {
        long na = Long.parseLong(oa);
        long nb = Long.parseLong(ob);
        return this.compareRevisions(na, nb);
    }

    public String getUri() {
        return this.ebuildRoot.toString();
    }

    public String fetchRevisionOfBranchHead(IVersion version) throws RepositoryPluginException {
        if (version.isTag()) {
            return null;
        }
        String branch = version.getBranch();
        String path = this.svnPath(branch);
        try {
            return this.revisionAsString(this.doFetchRevisionOfHead(this.svnUrl(path)));
        }
        catch (SVNException e) {
            throw this.handleGenericSvnErrors(e, path);
        }
    }

    public String fetchRevisionOfBranchCreation(IVersion version) throws RepositoryPluginException {
        if (version.isTag()) {
            return null;
        }
        String branch = version.getBranch();
        String path = this.svnPath(branch);
        SVNRevision peg = SVNRevision.HEAD;
        try {
            return this.revisionAsString(this.doFetchRevisionOfCopy(this.svnUrl(path), peg));
        }
        catch (SVNException e) {
            throw this.handleGenericSvnErrors(e, path);
        }
    }

    public String fetchRevisionOfLastChange(IElementKey key) throws RepositoryPluginException {
        String path = this.svnPath(key);
        try {
            SVNURL url = this.svnUrl(path);
            SVNRevision revision = this.doResolveSvnRevision(key.getVersion(), path);
            SVNInfo info = this.clientManager.getWCClient().doInfo(url, revision, revision);
            SVNRevision lcrevision = info.getCommittedRevision();
            return this.revisionAsString(lcrevision);
        }
        catch (SVNException e) {
            throw this.handleGenericSvnErrors(e, path);
        }
    }

    public String fetchRevisionOfHead() throws RepositoryPluginException {
        try {
            return this.revisionAsString(this.doFetchRevisionOfHead(this.repoRoot));
        }
        catch (SVNException e) {
            throw this.handleGenericSvnErrors(e, "/");
        }
    }

    public void fetchMeta(File metaDir, IElementKey key) throws RepositoryPluginException {
        String path = String.valueOf(this.svnPath(key)) + "/meta";
        try {
            SVNRevision revision = this.doResolveSvnRevision(key.getVersion(), path);
            this.doExport(metaDir, path, revision);
            Date timestamp = this.doFetchCommittedDate(path, revision);
            FileUtil.writeTimestampFile((File)metaDir, (Date)timestamp);
        }
        catch (SVNException e) {
            throw this.handleGenericSvnErrors(e, path);
        }
    }

    public void fetchProject(File projectDir, IElementKey key) throws RepositoryPluginException {
        String path = this.svnPath(key);
        try {
            SVNRevision revision = this.doResolveSvnRevision(key.getVersion(), path);
            this.doExport(projectDir, path, revision);
        }
        catch (SVNException e) {
            throw this.handleGenericSvnErrors(e, path);
        }
    }

    private long doExport(File dir, String path, SVNRevision revision) throws SVNException {
        if (revision == SVNRevision.HEAD) {
            throw new Error("Should not be exporting head revision!");
        }
        SVNURL url = this.svnUrl(path);
        return this.clientManager.getUpdateClient().doExport(url, dir, revision, revision, "\n", true, SVNDepth.INFINITY);
    }

    private SVNRevision doResolveSvnRevision(IVersion v, String path) throws SVNException {
        if (v.isHead()) {
            return SVNRevision.HEAD;
        }
        if (!v.isTag()) {
            return SVNRevision.parse((String)v.getRevision());
        }
        SVNURL url = this.svnUrl(path);
        return this.doFetchRevisionOfHead(url);
    }

    private Date doFetchCommittedDate(String path, SVNRevision revision) throws SVNException {
        SVNURL url = this.svnUrl(path);
        SVNInfo info = this.clientManager.getWCClient().doInfo(url, revision, revision);
        return info.getCommittedDate();
    }

    private SVNRevision doFetchRevisionOfCopy(SVNURL url, SVNRevision peg) throws SVNException {
        SVNRevision rNew = SVNRevision.HEAD;
        SVNRevision rOld = SVNRevision.create((long)0L);
        final ReturnRef r = new ReturnRef();
        this.clientManager.getLogClient().doLog(url, null, peg, rNew, rOld, true, true, false, -1L, null, new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                Map changedPaths = logEntry.getChangedPaths();
                if (changedPaths != null) {
                    for (String path : changedPaths.keySet()) {
                        SVNLogEntryPath entry = (SVNLogEntryPath)changedPaths.get(path);
                        if (entry.getCopyPath() == null) continue;
                        r.object = SVNRevision.create((long)logEntry.getRevision());
                    }
                }
            }
        });
        return (SVNRevision)r.object;
    }

    private SVNRevision doFetchRevisionOfHead(SVNURL url) throws SVNException {
        return this.doFetchRevisionOfHead(url, SVNRevision.HEAD);
    }

    private SVNRevision doFetchRevisionOfHead(SVNURL url, SVNRevision revision) throws SVNException {
        SVNInfo info = this.clientManager.getWCClient().doInfo(url, revision, revision);
        return info.getRevision();
    }

    private int compareRevisions(long na, long nb) {
        if (na == nb) {
            return 0;
        }
        if (na > nb) {
            return 1;
        }
        return -1;
    }

    private String revisionAsString(SVNRevision r) {
        if (r == null) {
            return null;
        }
        return "" + r.getNumber();
    }

    private RepositoryPluginException handleGenericSvnErrors(SVNException e, String path) {
        SVNErrorCode ecode = e.getErrorMessage().getErrorCode();
        if (ecode == SVNErrorCode.RA_DAV_REQUEST_FAILED) {
            return new RepositoryPluginException("Unable to connect to repository: " + this.repoRoot);
        }
        if (ecode == SVNErrorCode.RA_ILLEGAL_URL) {
            return new RepositoryPluginException("Unknown path in subversion: " + path + " @ " + this.getUri());
        }
        return new RepositoryPluginException((Throwable)e);
    }

    private String svnPath(IElementKey key) {
        String projName = String.valueOf(key.getOrg()) + "-" + key.getName();
        return String.valueOf(this.svnPath(key.getVersion())) + projName;
    }

    private String svnPath(IVersion v) {
        if (v.isTag()) {
            return "tags/" + v.getTag() + "/";
        }
        String branch = v.getBranch();
        return this.svnPath(branch);
    }

    private String svnPath(String branch) {
        if ("trunk".equals(branch)) {
            return "trunk/";
        }
        return "branches/" + branch + "/";
    }

    private SVNURL svnUrl(String path) {
        try {
            return this.ebuildRoot.appendPath(path, false);
        }
        catch (SVNException e) {
            throw new Error(e);
        }
    }

    public List<String> listProjects(IVersion version) throws RepositoryPluginException {
        try {
            String path = this.svnPath(version);
            SVNRepository repo = SVNRepositoryFactory.create((SVNURL)this.ebuildRoot);
            SVNRevision revision = this.doResolveSvnRevision(version, path);
            Collection entriesList = repo.getDir(path, revision.getNumber(), null, null);
            ArrayList<String> r = new ArrayList<String>(entriesList.size());
            for (SVNDirEntry entry : entriesList) {
                r.add(entry.getName());
            }
            return r;
        }
        catch (SVNException e) {
            throw new RepositoryPluginException((Throwable)e);
        }
    }
}

