package ebuild.repo.svn;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.api.repo.RepositoryPluginException;

public class SvnProvider extends AbstractRepositoryProvider {
	
	final private SVNClientManager clientManager = SVNClientManager.newInstance();
    private SvnLoginStore logins; 
    
	public SvnProvider(){
       SVNAdminAreaFactory.setSelector(new ISVNAdminAreaFactorySelector() {
            public Collection getEnabledFactories(File path, Collection factories, boolean writeAccess) throws                
            SVNException  {
                Collection enabledFactories = new TreeSet();
                for (Iterator factoriesIter = factories.iterator(); factoriesIter.hasNext(); ) {
                    SVNAdminAreaFactory factory = (SVNAdminAreaFactory)factoriesIter.next();
                    int version = factory.getSupportedVersion();
                    switch(version){
                    case SVNAdminAreaFactory.WC_FORMAT_13:
                    case SVNAdminAreaFactory.WC_FORMAT_14:
                    case SVNAdminAreaFactory.WC_FORMAT_15:
                    case SVNAdminAreaFactory.WC_FORMAT_16:
                        enabledFactories.add(factory);
                    default:
                    }
                }
                return enabledFactories;
            }
        });
	}
    @Override public void initCredentials(File credentialsFile) {
        this.logins = new SvnLoginStore(credentialsFile);
    }
	
	
    public SvnRepository getRepository(String url) throws RepositoryPluginException {
        SvnRepository r = repos.get(url);
        if(r==null){
            Login login = logins.getLogin(url);
            r = newRepository(url, login);
        }
        return r;
    }
    
    @Override public SvnWorkingDir getWorkingCopy(File dir) throws RepositoryPluginException {
        if(!new File(dir,".svn").isDirectory()){
            return null;
        }

        try {
			SVNInfo info = clientManager.getWCClient().doInfo(dir, SVNRevision.WORKING);
	        SvnRepository repo = getRepository(info.getRepositoryRootURL().toString());
//	        long revision = repo.getRevision(dir);
	        return new SvnWorkingDir(repo, dir);
		} catch (SVNException e) {
			throw new RepositoryPluginException(e);
		}
        
        
//        final SVNStatus status = clientManager.getStatusClient().doStatus(dir, false);
//        String url = status.getURL().toString();
//        // HACK determine root url without requiring a network connection!!
//        url = eliminatePath(url.toString());
        

    }
    
    private Map<String,SvnRepository> repos = new HashMap();
 
    public SvnRepository newRepository(String url, Login login) throws RepositoryPluginException{
        try{
            SvnRepository r = new SvnRepository(url, login);
            repos.put(url, r);
            return r;
        }catch(SVNException e){
            throw new RepositoryPluginException(e);
        }
    }

   

//    
//    static private String eliminatePath(String url){
//        int i;
//        i= url.indexOf("trunk");
//        if(i!=-1){
//            return url.substring(0,i);
//        }
//        i= url.indexOf("branches");
//        if(i!=-1){
//            return url.substring(i);
//        }
//        return url;
//    }

}
