/*
 * Decompiled with CFR 0.152.
 */
package ebuild.repo.svn;

import ebuild.repo.svn.Login;
import ebuild.util.CollectionUtil;
import ebuild.util.JSONUtil;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class SvnLoginStore {
    private final Map<String, String> values;

    public SvnLoginStore(File logins) {
        try {
            this.values = logins.isFile() ? (Map)JSONUtil.readObject((Reader)new FileReader(logins)) : CollectionUtil.EMPTY_MAP;
        }
        catch (Exception e) {
            throw new Error("Could not read file: " + logins, e);
        }
    }

    public Login getLogin(String url) {
        String u_p = this.values.get(url);
        if (u_p != null) {
            return new Login(u_p);
        }
        return null;
    }

    public Login getLogin(SVNURL url) throws SVNException {
        SVNURL last = null;
        while (!url.equals(last)) {
            String s = url.toString();
            String u_p = this.values.get(s);
            if (u_p != null) {
                return new Login(u_p);
            }
            last = url;
            url = url.removePathTail();
        }
        return null;
    }
}

