/*
 * Decompiled with CFR 0.152.
 */
package ebuild.repo.svn;

import ebuild.api.common.IElementKey;
import ebuild.api.common.IVersion;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.repo.svn.Login;
import ebuild.util.FileUtil;
import java.io.File;
import java.util.Date;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnRepository
extends AbstractSourceRepository {
    public final SVNURL rootUrl;
    public final SVNClientManager clientManager;

    public SvnRepository(String rootUrl, Login login) throws SVNException {
        this(SVNURL.parseURIEncoded((String)rootUrl), login);
    }

    public SvnRepository(SVNURL rootUrl, Login login) throws SVNException {
        String protocol = rootUrl.getProtocol();
        if ("svn".equals(protocol)) {
            SVNRepositoryFactoryImpl.setup();
        } else if ("http".equals(protocol) || "https".equals(protocol)) {
            DAVRepositoryFactory.setup();
        } else if ("file".equals(protocol)) {
            FSRepositoryFactory.setup();
        }
        this.rootUrl = rootUrl;
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        this.clientManager = login != null ? SVNClientManager.newInstance((DefaultSVNOptions)options, (String)login.username, (String)login.password) : SVNClientManager.newInstance((ISVNOptions)options);
    }

    public String getUri() {
        return this.rootUrl.toString();
    }

    public String getUniverse() {
        return "ebuild";
    }

    public String getLastChangeRevision(IElementKey key) throws RepositoryPluginException {
        String path = this.svnPath(key);
        try {
            SVNURL url = this.svnUrl(path);
            SVNRevision revision = this.svnRevision(key.getVersion());
            SVNInfo info = this.clientManager.getWCClient().doInfo(url, revision, revision);
            SVNRevision lcrevision = info.getCommittedRevision();
            return lcrevision.getNumber() + "";
        }
        catch (SVNException e) {
            throw this.handleGenericSvnErrors(e, path);
        }
    }

    protected String doGetHeadRevision() throws RepositoryPluginException {
        try {
            SVNInfo info = this.clientManager.getWCClient().doInfo(this.rootUrl, SVNRevision.HEAD, SVNRevision.HEAD);
            return info.getRevision().toString();
        }
        catch (SVNException e) {
            throw new RepositoryPluginException(e.getMessage());
        }
    }

    public void fetchMeta(File metaDir, IElementKey key) throws RepositoryPluginException {
        String path = this.svnPath(key) + "/meta";
        SVNRevision revision = this.svnRevision(key.getVersion());
        this.export(metaDir, path, revision);
        Date timestamp = this.fetchCommittedDate(path, revision);
        FileUtil.writeTimestampFile((File)metaDir, (Date)timestamp);
    }

    public void fetchProject(File projectDir, IElementKey key) throws RepositoryPluginException {
        String path = this.svnPath(key);
        SVNRevision revision = this.svnRevision(key.getVersion());
        this.export(projectDir, path, revision);
    }

    private Date fetchCommittedDate(String path, SVNRevision revision) throws RepositoryPluginException {
        try {
            SVNURL url = this.svnUrl(path);
            SVNInfo info = this.clientManager.getWCClient().doInfo(url, revision, revision);
            return info.getCommittedDate();
        }
        catch (SVNException e) {
            throw this.handleGenericSvnErrors(e, path);
        }
    }

    private long export(File dir, String path, SVNRevision revision) throws RepositoryPluginException {
        if (revision == SVNRevision.HEAD) {
            throw new Error("Should not be exporting head revision!");
        }
        try {
            SVNURL url = this.svnUrl(path);
            return this.clientManager.getUpdateClient().doExport(url, dir, revision, revision, "\n", true, SVNDepth.INFINITY);
        }
        catch (SVNException e) {
            throw this.handleGenericSvnErrors(e, path);
        }
    }

    public String toString() {
        return "svn / " + this.rootUrl;
    }

    private RepositoryPluginException handleGenericSvnErrors(SVNException e, String path) {
        SVNErrorCode ecode = e.getErrorMessage().getErrorCode();
        if (ecode == SVNErrorCode.RA_DAV_REQUEST_FAILED) {
            return new RepositoryPluginException("Unable to connect to repository: " + this.rootUrl);
        }
        if (ecode == SVNErrorCode.RA_ILLEGAL_URL) {
            return new RepositoryPluginException("Unknown path in subversion: " + path + " @ " + this.getUri());
        }
        return new RepositoryPluginException((Throwable)e);
    }

    private SVNRevision svnRevision(IVersion v) {
        if (v.isHead()) {
            return SVNRevision.HEAD;
        }
        if (!v.isTag()) {
            return SVNRevision.parse((String)v.getRevision());
        }
        throw new RuntimeException("Tags not supported yet");
    }

    private String svnPath(IElementKey key) {
        String projName = key.getOrg() + "-" + key.getName();
        IVersion v = key.getVersion();
        if (v.isTag()) {
            return v.getTag() + "/" + projName;
        }
        return v.getBranch() + "/" + projName;
    }

    private SVNURL svnUrl(String path) {
        try {
            return this.rootUrl.appendPath(path, false);
        }
        catch (SVNException e) {
            throw new Error(e);
        }
    }
}

