package ebuild.repo.svn;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;

import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNWCClient;

import ebuild.api.repo.AbstractWorkingCopy;

public class SvnWorkingDir extends AbstractWorkingCopy{
	
    final SvnRepository repo;
	final File dir;
	
    public SvnWorkingDir(SvnRepository repo, File dir) {
		this.repo = repo;
		this.dir = dir;
    }
    public SvnRepository getRepository() { return repo; }
    public void addIgnores(Collection<String> ignores){
        try{
            String val = readLocalProperty(dir, SVNProperty.IGNORE, "");
            String val2 = appendIgnores(val, ignores);
            
            if(!val2.equals(val)){
                SVNWCClient client = repo.clientManager.getWCClient();
                client.doSetProperty(dir, SVNProperty.IGNORE, SVNPropertyValue.create(val2), false, SVNDepth.EMPTY, null, null);
            }
            
            
            
        }catch(Exception e){
            throw new Error(e);
        }
    }
    
    @Override public String getBranch() {
    	try {
    		String rootUri = getRepository().getUri();
        	SVNStatus status = repo.clientManager.getStatusClient().doStatus(new File("."), false);
        	String dirUri = status.getURL().toString();
        	String path = dirUri.substring(rootUri.length());
        	if(path.startsWith("/branches/")){
        		String[] segments = path.substring(1).split("/");
        		String branch = segments[1];
        		return branch;
        	}
        	return null;
		} catch (SVNException e) {
			throw new Error(e);
		}
    }
    
//    public String getMessage() { return message; }
//    public void setMessage(String message) { this.message = message; }
//    
//    public long getRevision() throws SVNException{
//        return revision;
//    }
//    public String getVersion() { return "r"+revision; }
//    public boolean isDirty() { return dirty; }

    private String appendIgnores(String value, Collection<String> ignores){
        Collection<String> add = new HashSet(ignores);
        String[] vs = value.split("\n");
        for(String v: vs){
            add.remove(v);
        }
        
        String r = value;
        for(String s: add){
            r+="\n"+s+"\n";
        }
        return r;
    }
    
    private String readLocalProperty(File dir, String name, String default_) throws SVNException{
        final SVNPropertyValue[] r = new SVNPropertyValue[1];
        SVNWCClient client = repo.clientManager.getWCClient();
        client.doGetProperty(dir, name, SVNRevision.WORKING, SVNRevision.WORKING, SVNDepth.EMPTY, new ISVNPropertyHandler() {
            public void handleProperty(long revision, SVNPropertyData property) throws SVNException {}
            
            public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {}
            
            public void handleProperty(File path, SVNPropertyData property) throws SVNException { r[0] = property.getValue(); }
        }, null);
        
        return r[0]==null?"":r[0].toString();
    }
    
    public String toString() {
        return repo+" ";
    }
}
