/*
 * Decompiled with CFR 0.152.
 */
package ebuild.repo.svn;

import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.repo.svn.Login;
import ebuild.repo.svn.SvnLoginStore;
import ebuild.repo.svn.SvnRepository;
import ebuild.repo.svn.SvnWorkingDir;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnProvider
extends AbstractRepositoryProvider {
    private final SVNClientManager clientManager = SVNClientManager.newInstance();
    private SvnLoginStore logins;
    private Map<String, SvnRepository> repos = new HashMap<String, SvnRepository>();

    public SvnProvider() {
        SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new ISVNAdminAreaFactorySelector(){

            public Collection getEnabledFactories(File path, Collection factories, boolean writeAccess) throws SVNException {
                TreeSet<SVNAdminAreaFactory> enabledFactories = new TreeSet<SVNAdminAreaFactory>();
                for (SVNAdminAreaFactory factory : factories) {
                    int version = factory.getSupportedVersion();
                    switch (version) {
                        case 4: 
                        case 8: 
                        case 9: 
                        case 10: {
                            enabledFactories.add(factory);
                        }
                    }
                }
                return enabledFactories;
            }
        });
    }

    public void initCredentials(File credentialsFile) {
        this.logins = new SvnLoginStore(credentialsFile);
    }

    public SvnRepository getRepository(String url) throws RepositoryPluginException {
        SvnRepository r = this.repos.get(url);
        if (r == null) {
            Login login = this.logins.getLogin(url);
            r = this.newRepository(url, login);
        }
        return r;
    }

    public SvnWorkingDir getWorkingCopy(File dir) throws RepositoryPluginException {
        if (!new File(dir, ".svn").isDirectory()) {
            return null;
        }
        try {
            SVNInfo info = this.clientManager.getWCClient().doInfo(dir, SVNRevision.WORKING);
            SvnRepository repo = this.getRepository(info.getRepositoryRootURL().toString());
            return new SvnWorkingDir(repo, dir);
        }
        catch (SVNException e) {
            throw new RepositoryPluginException((Throwable)e);
        }
    }

    public SvnRepository newRepository(String url, Login login) throws RepositoryPluginException {
        try {
            SvnRepository r = new SvnRepository(url, login);
            this.repos.put(url, r);
            return r;
        }
        catch (SVNException e) {
            throw new RepositoryPluginException((Throwable)e);
        }
    }
}

