/*
 * Decompiled with CFR 0.152.
 */
package simpleorm.drivers;

import simpleorm.dataset.SFieldMeta;
import simpleorm.dataset.SFieldScalar;
import simpleorm.dataset.SRecordMeta;
import simpleorm.sessionjdbc.SDriver;
import simpleorm.sessionjdbc.SGenerator;

public abstract class SDriverHSQLH2
extends SDriver {
    @Override
    public boolean supportsLocking() {
        return false;
    }

    @Override
    protected String columnTypeSQL(SFieldScalar field, String defalt) {
        if (defalt.equals("BYTES")) {
            return "BINARY";
        }
        if (defalt.equals("NUMERIC(18,0)")) {
            return "BIGINT";
        }
        return defalt;
    }

    @Override
    protected String addInsertGenerator(SFieldMeta fld) {
        return " IDENTITY ";
    }

    @Override
    protected long generateKeySequence(SRecordMeta<?> rec, SFieldScalar keyFld) {
        String sequenceName = ((SGenerator)keyFld.getGenerator()).getName();
        String qry = "CALL NEXT VALUE FOR " + sequenceName;
        Object next = this.getSession().rawQuerySingle(qry, false, new Object[0]);
        if (next == null) {
            return 0L;
        }
        if (next instanceof Number) {
            return ((Number)next).longValue();
        }
        return Long.parseLong(next.toString());
    }

    @Override
    public boolean supportsKeySequences() {
        return true;
    }

    @Override
    protected String createSequenceDDL(String name) {
        return "CREATE SEQUENCE " + name;
    }

    @Override
    protected String dropSequenceDDL(String name) {
        return "DROP SEQUENCE " + name;
    }

    @Override
    public boolean supportsInsertKeyGeneration() {
        return true;
    }

    @Override
    protected long retrieveInsertedKey(SRecordMeta<?> rec, SFieldScalar keyFld) {
        String qry = "CALL IDENTITY()";
        Object next = this.getSession().rawQuerySingle(qry, false, new Object[0]);
        if (next == null) {
            return 0L;
        }
        if (next instanceof Number) {
            return ((Number)next).longValue();
        }
        return Long.parseLong(next.toString());
    }

    @Override
    protected SDriver.OffsetStrategy getOffsetStrategy() {
        return SDriver.OffsetStrategy.QUERY;
    }

    @Override
    protected String limitSQL(long offset, long limit) {
        StringBuffer sb = new StringBuffer();
        if (limit != Integer.MAX_VALUE) {
            sb.append(" LIMIT " + limit);
        }
        if (offset > 0L) {
            sb.append(" OFFSET " + offset);
        }
        return sb.toString();
    }
}

