/*
 * Decompiled with CFR 0.152.
 */
package simpleorm.drivers;

import simpleorm.dataset.SFieldScalar;
import simpleorm.dataset.SRecordMeta;
import simpleorm.sessionjdbc.SDriver;
import simpleorm.sessionjdbc.SGenerator;

public class SDriverPostgres
extends SDriver {
    @Override
    protected String driverName() {
        return "PostgreSQL Native Driver";
    }

    @Override
    public int maxIdentNameLength() {
        return 60;
    }

    @Override
    protected String columnTypeSQL(SFieldScalar field, String defalt) {
        if (defalt.startsWith("VARCHAR")) {
            return "VARCHAR";
        }
        if (defalt.equals("BYTES")) {
            return "BYTEA";
        }
        return defalt;
    }

    @Override
    protected long generateKeySequence(SRecordMeta<?> rec, SFieldScalar keyFld) {
        String sequenceName = ((SGenerator)keyFld.getGenerator()).getName();
        String qry = "SELECT nextval('" + sequenceName + "')";
        Object next = this.getSession().rawQuerySingle(qry, false, new Object[0]);
        if (next == null) {
            return 0L;
        }
        if (next instanceof Number) {
            return ((Number)next).longValue();
        }
        return Long.parseLong(next.toString());
    }

    @Override
    public boolean supportsKeySequences() {
        return true;
    }

    @Override
    protected String createSequenceDDL(String name) {
        return "CREATE SEQUENCE " + name;
    }

    @Override
    protected String dropSequenceDDL(String name) {
        return "DROP SEQUENCE " + name;
    }

    @Override
    protected SDriver.OffsetStrategy getOffsetStrategy() {
        return SDriver.OffsetStrategy.QUERY;
    }

    @Override
    protected String limitSQL(long offset, long limit) {
        return " LIMIT " + limit + " OFFSET " + offset;
    }
}

