/*
 * Decompiled with CFR 0.152.
 */
package simpleorm.sessionjdbc;

import java.lang.reflect.Array;
import java.util.ArrayList;
import simpleorm.dataset.SFieldMeta;
import simpleorm.dataset.SFieldScalar;
import simpleorm.dataset.SQueryMode;
import simpleorm.dataset.SRecordInstance;
import simpleorm.dataset.SRecordMeta;
import simpleorm.sessionjdbc.SSessionJdbc;
import simpleorm.utils.SException;

public class SDataLoader<T extends SRecordInstance> {
    SSessionJdbc session;
    SRecordMeta<T> sRecordMeta = null;
    SFieldScalar[] sFieldMetas = null;
    SFieldScalar[] keyMetas = null;

    public SDataLoader(SSessionJdbc session, SRecordMeta<T> meta, SFieldScalar[] fields) {
        this.session = session;
        this.sRecordMeta = meta;
        ArrayList<SFieldScalar> flds = new ArrayList<SFieldScalar>();
        ArrayList<SFieldScalar> keys = new ArrayList<SFieldScalar>();
        for (SFieldScalar fld : fields) {
            if (fld.getGeneratorMode() != null) continue;
            flds.add(fld);
            if (!fld.isPrimary()) continue;
            keys.add(fld);
        }
        this.sFieldMetas = flds.toArray(new SFieldScalar[0]);
        this.keyMetas = keys.toArray(new SFieldScalar[0]);
    }

    public SDataLoader(SSessionJdbc session, SRecordMeta<T> meta) {
        this(session, meta, meta.getQueriedScalarFields());
    }

    public SRecordInstance insertRecord(Object ... record) {
        if (record == null || record.length != this.sFieldMetas.length) {
            throw new SException.Error(this.sFieldMetas.length + " columns required in parameter array.");
        }
        SRecordInstance rec = null;
        int nrKeys = this.keyMetas.length;
        if (nrKeys > 0) {
            Object[] keys = new Object[nrKeys];
            int index = 0;
            for (int kx = 0; kx < nrKeys; ++kx) {
                keys[index] = record[kx];
                ++index;
            }
            rec = (SRecordInstance)this.session.findOrCreate(this.sRecordMeta, this.sFieldMetas, SQueryMode.SFOR_UPDATE, keys);
        } else {
            rec = (SRecordInstance)this.session.createWithGeneratedKey(this.sRecordMeta);
        }
        int cx = 0;
        for (SFieldScalar fld : this.sFieldMetas) {
            if (!fld.isPrimary()) {
                rec.setObject((SFieldMeta)fld, record[cx]);
            }
            ++cx;
        }
        return rec;
    }

    public SRecordInstance[] insertRecords(Object[][] records) {
        SRecordInstance[] res = (SRecordInstance[])Array.newInstance(this.sRecordMeta.getUserClass(), records.length);
        for (int x = 0; x < records.length; ++x) {
            res[x] = this.insertRecord(records[x]);
        }
        return res;
    }
}

