/*
 * Decompiled with CFR 0.152.
 */
package simpleorm.sessionjdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import simpleorm.dataset.SFieldMeta;
import simpleorm.dataset.SFieldReference;
import simpleorm.dataset.SFieldScalar;
import simpleorm.dataset.SGeneratorMode;
import simpleorm.dataset.SQuery;
import simpleorm.dataset.SQueryTable;
import simpleorm.dataset.SQueryTransient;
import simpleorm.dataset.SRecordInstance;
import simpleorm.dataset.SRecordMeta;
import simpleorm.drivers.SDriverDB2_400;
import simpleorm.drivers.SDriverDerby;
import simpleorm.drivers.SDriverFirebird;
import simpleorm.drivers.SDriverH2;
import simpleorm.drivers.SDriverHSQL;
import simpleorm.drivers.SDriverInformix;
import simpleorm.drivers.SDriverInterbase;
import simpleorm.drivers.SDriverMSSQL;
import simpleorm.drivers.SDriverMySQL;
import simpleorm.drivers.SDriverOracle;
import simpleorm.drivers.SDriverPostgres;
import simpleorm.drivers.SDriverSapDB;
import simpleorm.drivers.SDriverSybase;
import simpleorm.sessionjdbc.SQueryExecute;
import simpleorm.sessionjdbc.SQueryTransientExecute;
import simpleorm.sessionjdbc.SSessionJdbc;
import simpleorm.utils.SException;
import simpleorm.utils.SLog;

public class SDriver {
    SSessionJdbc session;
    private static ArrayList<SDriver> drivers = new ArrayList();

    protected SDriver() {
    }

    static SDriver newSDriver(Connection con) {
        String databaseName = null;
        String driverName = null;
        try {
            driverName = con.getMetaData().getDriverName();
            databaseName = con.getMetaData().getDatabaseProductName();
        }
        catch (Exception ex) {
            throw new SException.Jdbc((Throwable)ex);
        }
        for (int dx = 0; dx < drivers.size(); ++dx) {
            SDriver driver = drivers.get(dx);
            if (!driver.driverName().equals(driverName)) continue;
            try {
                return (SDriver)driver.getClass().newInstance();
            }
            catch (Exception ex) {
                throw new SException.Error((Throwable)ex);
            }
        }
        SLog.getSessionlessLogger().warn("Unknown Database '" + databaseName + "' driver '" + driverName + "'. Using generic SDriver.");
        SDriver drv = new SDriver();
        return drv;
    }

    public void registerDriver() {
        drivers.add(this);
    }

    protected String driverName() {
        return "Generic Driver";
    }

    protected <RI extends SRecordInstance> SQueryExecute<RI> queryExecuteFactory(SSessionJdbc session, SQuery<RI> query) {
        return new SQueryExecute<RI>(session, query);
    }

    protected SQueryTransientExecute queryExecuteFactory(SSessionJdbc session, SQueryTransient query) {
        return new SQueryTransientExecute(session, query);
    }

    protected void appendQuotedIdentifier(String ident, StringBuffer buf) {
        this.appendQuotedIdentifier(ident, buf, '\"');
    }

    protected void appendQuotedIdentifier(String ident, StringBuffer buf, char quote) {
        if (ident.length() > this.maxIdentNameLength()) {
            throw new SException.Error("Identifier '" + ident + "' is longer than " + this.maxIdentNameLength() + " chars as permitted by " + this.driverName());
        }
        buf.append(quote);
        for (int cx = 0; cx < ident.length(); ++cx) {
            char ch = ident.charAt(cx);
            buf.append(ch);
            if (ch != quote) continue;
            buf.append(quote);
        }
        buf.append(quote);
    }

    public void appendColumnName(SFieldScalar field, StringBuffer buf) {
        String name = field.getColumnName();
        if (field.quoteName) {
            this.appendQuotedIdentifier(name, buf);
        } else {
            buf.append(name);
        }
    }

    public void appendTableName(SRecordMeta<?> table, StringBuffer buf) {
        String name = table.getTableName();
        if (table.quoteName) {
            this.appendQuotedIdentifier(name, buf);
        } else {
            buf.append(name);
        }
    }

    public boolean appendAliasIfNecessary(SQueryTable<?> table, StringBuffer buf) {
        if (!table.getAlias().equals(table.getRecordMeta().getTableName())) {
            buf.append(" ").append(table.getAlias());
            return true;
        }
        return false;
    }

    public int maxIdentNameLength() {
        return 30;
    }

    public boolean supportsLocking() {
        return true;
    }

    public boolean supportsBatchUpdates() {
        try {
            DatabaseMetaData dbmeta = this.session.jdbcConnection.getMetaData();
            if (dbmeta != null && dbmeta.supportsBatchUpdates()) {
                return true;
            }
        }
        catch (SQLException ex) {
            throw new SException.Jdbc("Trying to determine batch update support ", (Throwable)ex);
        }
        catch (AbstractMethodError err) {
            throw new SException.Jdbc("JDBC driver does not implement Jdbc 2.0 'supportsBatchUpdates' method", (Throwable)err);
        }
        return false;
    }

    public String alterTableAddColumnSQL(SFieldScalar field) {
        StringBuffer sql = new StringBuffer();
        sql.append("\nALTER TABLE ");
        this.appendTableName(field.getRecordMeta(), sql);
        sql.append(" ADD COLUMN ");
        sql.append(this.wholeColumnSQL(field));
        sql.append(this.clauseSeparator("    "));
        return sql.toString();
    }

    public String alterTableDropColumnSQL(SFieldScalar field) {
        StringBuffer sql = new StringBuffer();
        sql.append("\nALTER TABLE ");
        this.appendTableName(field.getRecordMeta(), sql);
        sql.append(" DROP COLUMN ");
        this.appendColumnName(field, sql);
        sql.append(this.clauseSeparator("    "));
        return sql.toString();
    }

    public String createTableSQL(SRecordMeta<?> meta) {
        StringBuffer sql = new StringBuffer(1000);
        sql.append("\nCREATE TABLE ");
        this.appendTableName(meta, sql);
        sql.append("(");
        for (SFieldMeta fld : meta.getFieldMetas()) {
            Object cq = null;
            if (fld instanceof SFieldReference || cq != null) continue;
            sql.append(this.clauseSeparator("    "));
            sql.append(this.wholeColumnSQL((SFieldScalar)fld));
            sql.append(", ");
        }
        sql.append(this.clauseSeparator("    "));
        sql.append(this.primaryKeySQL(meta));
        sql.append(this.indexKeySQL(meta));
        sql.append(this.foreignKeysSQL(meta));
        sql.append(this.postTablePreParenSQL(meta));
        sql.append(")");
        sql.append(this.postTablePostParenSQL(meta));
        sql.append(this.clauseSeparator("    "));
        return sql.toString();
    }

    protected String clauseSeparator(String indent) {
        return "\n" + indent;
    }

    protected String wholeColumnSQL(SFieldScalar fld) {
        StringBuffer sql = new StringBuffer(60);
        this.appendColumnName(fld, sql);
        int len = fld.getColumnName().length();
        sql.append("                 ".substring(len > 15 ? 15 : len - 1));
        if (fld.sqlDataTypeOverride != null) {
            sql.append(fld.sqlDataTypeOverride);
        } else {
            sql.append(this.columnTypeSQL(fld, fld.defaultSqlDataType()));
        }
        this.addNull(sql, fld);
        if (fld.getGeneratorMode() == SGeneratorMode.SINSERT) {
            sql.append(this.addInsertGenerator((SFieldMeta)fld));
        }
        sql.append(this.postColumnSQL((SFieldMeta)fld));
        return sql.toString();
    }

    protected void addNull(StringBuffer sql, SFieldScalar fld) {
        if (fld.isPrimary() || fld.isMandatory()) {
            sql.append(" NOT NULL");
        } else {
            sql.append(" NULL");
        }
    }

    protected String columnTypeSQL(SFieldScalar field, String defalt) {
        return defalt;
    }

    protected String addInsertGenerator(SFieldMeta fld) {
        throw new SException.Error("This database does not support SINSERT key generation");
    }

    protected String postColumnSQL(SFieldMeta field) {
        return "";
    }

    protected String primaryKeySQL(SRecordMeta<?> meta) {
        StringBuffer pkey = new StringBuffer("PRIMARY KEY (");
        boolean firstpk = true;
        for (SFieldScalar fld : meta.getPrimaryKeys()) {
            if (!firstpk) {
                pkey.append(", ");
            }
            firstpk = false;
            this.appendColumnName(fld, pkey);
        }
        pkey.append(")");
        return pkey.toString();
    }

    protected String indexKeySQL(SRecordMeta<?> meta) {
        return "";
    }

    protected String foreignKeysSQL(SRecordMeta<?> meta) {
        return this.mapForeignKeys(meta, true);
    }

    protected String mapForeignKeys(SRecordMeta<?> meta, boolean foreignKey) {
        StringBuffer fkey = new StringBuffer("");
        List fields = meta.getFieldMetas();
        for (SFieldMeta fld : fields) {
            int fx = fields.indexOf(fld);
            if (!(fld instanceof SFieldReference)) continue;
            SFieldReference fldRef = (SFieldReference)fld;
            StringBuffer sbFkey = new StringBuffer(40);
            StringBuffer sbRefed = new StringBuffer(40);
            for (SFieldScalar fk : fldRef.getForeignKeyMetas()) {
                if (sbFkey.length() > 0) {
                    sbFkey.append(", ");
                }
                this.appendColumnName(fk, sbFkey);
                SFieldScalar pk = fldRef.getPrimaryKeyForForegnKey(fk);
                if (sbRefed.length() > 0) {
                    sbRefed.append(", ");
                }
                this.appendColumnName(pk, sbRefed);
            }
            if (foreignKey) {
                this.makeForeignKeySQL(meta, fx, fldRef, sbFkey, sbRefed, fkey);
                continue;
            }
            this.makeForeignKeyIndexSQL(meta, fx, fldRef, sbFkey, sbRefed, fkey);
        }
        return fkey.toString();
    }

    private void makeForeignKeySQL(SRecordMeta<?> meta, int fx, SFieldReference<?> fldRef, StringBuffer sbFkey, StringBuffer sbRefed, StringBuffer fkey) {
        fkey.append(",\n    CONSTRAINT ");
        String tname = meta.getTableName();
        String fxStr = fx + "";
        int spare = this.maxIdentNameLength() - tname.length() - fxStr.length() - 1;
        if (spare < 0) {
            throw new SException.Error("Table name '" + tname + "' is longer than " + this.maxIdentNameLength() + " - " + (fxStr.length() + 1) + " chars as permitted by " + this.driverName() + " to allow for _nn constraint name.");
        }
        String fkeyName = tname + "_" + fxStr;
        String fname = fldRef.getFieldName();
        if (spare > 1) {
            fkeyName = fkeyName + "_";
        }
        if (spare > fname.length()) {
            fkeyName = fkeyName + fname;
        } else if (spare > 0) {
            fkeyName = fkeyName + fname.substring(0, spare - 1);
        }
        this.appendQuotedIdentifier(fkeyName, fkey);
        fkey.append("\n      FOREIGN KEY (");
        fkey.append(sbFkey);
        fkey.append(")\n      REFERENCES ");
        this.appendTableName(fldRef.getReferencedRecordMeta(), fkey);
        fkey.append(" (");
        fkey.append(sbRefed.toString());
        fkey.append(")");
    }

    protected void makeForeignKeyIndexSQL(SRecordMeta<?> meta, int fx, SFieldReference<?> fldRef, StringBuffer sbFkey, StringBuffer sbRefed, StringBuffer fkey) {
    }

    protected String postTablePreParenSQL(SRecordMeta<?> meta) {
        return "";
    }

    protected String postTablePostParenSQL(SRecordMeta<?> meta) {
        return "";
    }

    protected <RI extends SRecordInstance> String selectSQL(SFieldScalar[] select, SRecordMeta<RI> from, SFieldScalar[] where, String orderBy, boolean forUpdate) {
        StringBuffer selectBuf = new StringBuffer(100);
        boolean first = true;
        for (SFieldScalar sfld : select) {
            if (!first) {
                selectBuf.append(", ");
            }
            this.appendColumnName(sfld, selectBuf);
            first = false;
        }
        StringBuffer wherestr = new StringBuffer(100);
        first = true;
        for (SFieldScalar wfld : where) {
            if (!first) {
                wherestr.append(" AND ");
            }
            this.appendColumnName(wfld, wherestr);
            wherestr.append(" = ? ");
            first = false;
        }
        return this.selectSQL(selectBuf.toString(), this.fromSQL(new SQueryTable(from.getTableName(), from, select, 1)), null, wherestr.toString(), null, orderBy, forUpdate, Integer.MAX_VALUE, 0L);
    }

    protected String selectSQL(String select, String fromClause, String joinClause, String where, String groupBy, String orderBy, boolean forUpdate, long limit, long offset) {
        StringBuffer sqlbuf = new StringBuffer(200);
        sqlbuf.append("SELECT ").append(select);
        sqlbuf.append(this.clauseSeparator(""));
        sqlbuf.append(fromClause);
        sqlbuf.append(this.clauseSeparator(""));
        if (joinClause != null) {
            sqlbuf.append(" ").append(joinClause).append(" ");
        }
        sqlbuf.append(this.postFromSQL(forUpdate));
        if (where != null) {
            sqlbuf.append(" WHERE " + where);
            sqlbuf.append(this.clauseSeparator(""));
        }
        if (groupBy != null) {
            sqlbuf.append(" GROUP BY " + groupBy);
            sqlbuf.append(this.clauseSeparator(""));
        }
        if (orderBy != null) {
            sqlbuf.append(" ORDER BY " + orderBy);
            sqlbuf.append(this.clauseSeparator(""));
        }
        sqlbuf.append(this.forUpdateSQL(forUpdate));
        if ((offset != 0L || limit != Integer.MAX_VALUE) && this.getOffsetStrategy().equals((Object)OffsetStrategy.QUERY)) {
            if (orderBy == null) {
                this.getLogger().warn("Order by is strongly recommended when using limit/offset");
            }
            sqlbuf.append(this.limitSQL(offset, limit));
        }
        return sqlbuf.toString();
    }

    protected String forUpdateSQL(boolean forUpdate) {
        if (this.supportsLocking() && forUpdate) {
            return " FOR UPDATE";
        }
        return "";
    }

    protected String limitSQL(long offset, long limit) {
        this.getLogger().warn("Warning, inconsistent SDriver. Limit won't work");
        return "";
    }

    protected String fromSQL(SQueryTable<?> from) {
        StringBuffer res = new StringBuffer();
        res.append(" FROM ");
        this.appendTableName(from.getRecordMeta(), res);
        this.appendAliasIfNecessary(from, res);
        res.append(" ");
        return res.toString();
    }

    protected String joinSQL(SQueryTable<?> table) {
        StringBuffer res = new StringBuffer(800);
        res.append(table.getType().toString()).append(" JOIN ");
        this.appendTableName(table.getRecordMeta(), res);
        res.append(" ");
        this.appendAliasIfNecessary(table, res);
        res.append(" ON ");
        if (table.getRawOnClause() != null) {
            res.append(table.getRawOnClause());
        } else {
            boolean first = true;
            boolean oneToManyJoin = table.getFieldReference().getRecordMeta() == table.getRecordMeta() && table.getFieldReference().getReferencedRecordMeta() != table.getRecordMeta();
            for (SFieldScalar fkey : table.getFieldReference().getForeignKeyMetas()) {
                if (!first) {
                    res.append(" AND ");
                }
                if (oneToManyJoin) {
                    this.appendField(table, fkey, res);
                    res.append(" = ");
                    this.appendField(table.getFromTable(), table.getFieldReference().getPrimaryKeyForForegnKey(fkey), res);
                } else {
                    this.appendField(table.getFromTable(), fkey, res);
                    res.append(" = ");
                    this.appendField(table, table.getFieldReference().getPrimaryKeyForForegnKey(fkey), res);
                }
                first = false;
            }
        }
        return res.toString();
    }

    protected String postFromSQL(boolean forUpdate) {
        return "";
    }

    protected String updateSQL(ArrayList<SFieldScalar> updates, SRecordMeta<?> from, ArrayList<SFieldScalar> where, SRecordInstance instance, Object[] keyMetaValues) {
        StringBuffer ret = new StringBuffer(200);
        ret.append("UPDATE ");
        this.appendTableName(from, ret);
        ret.append(" SET ");
        for (int sx = 0; sx < updates.size(); ++sx) {
            if (sx > 0) {
                ret.append(", ");
            }
            SFieldScalar sfld = updates.get(sx);
            this.appendColumnName(sfld, ret);
            ret.append(" = ?");
        }
        this.whereSQL(ret, where, instance, keyMetaValues);
        return ret.toString();
    }

    protected String insertSQL(ArrayList<SFieldScalar> updates, SRecordMeta<?> from) {
        int sx;
        StringBuffer ret = new StringBuffer(800);
        ret.append("INSERT INTO ");
        this.appendTableName(from, ret);
        ret.append(" (");
        for (sx = 0; sx < updates.size(); ++sx) {
            if (sx > 0) {
                ret.append(", ");
            }
            SFieldScalar sfld = updates.get(sx);
            this.appendColumnName(sfld, ret);
        }
        ret.append(") VALUES (");
        for (sx = 0; sx < updates.size(); ++sx) {
            if (sx > 0) {
                ret.append(", ");
            }
            ret.append("?");
        }
        ret.append(")");
        return ret.toString();
    }

    protected String deleteSQL(SRecordMeta<?> from, ArrayList<SFieldScalar> where, SRecordInstance instance, Object[] keyMetaValues) {
        StringBuffer ret = new StringBuffer(200);
        ret.append("DELETE FROM ");
        this.appendTableName(from, ret);
        this.whereSQL(ret, where, instance, keyMetaValues);
        return ret.toString();
    }

    protected void whereSQL(StringBuffer ret, ArrayList<SFieldScalar> where, SRecordInstance instance, Object[] keyMetaValues) {
        ret.append(" WHERE ");
        for (int wx = 0; wx < where.size(); ++wx) {
            if (wx > 0) {
                ret.append(" AND ");
            }
            SFieldScalar wfld = where.get(wx);
            Object value = keyMetaValues[wx];
            this.appendColumnName(wfld, ret);
            ret.append(value != null ? " = ? " : " IS NULL ");
        }
    }

    protected void appendField(SQueryTable<?> tbl, SFieldScalar sclField, StringBuffer buf) {
        boolean aliased = this.appendAliasIfNecessary(tbl, buf);
        if (!aliased) {
            this.appendTableName(tbl.getRecordMeta(), buf);
        }
        buf.append(".");
        this.appendColumnName(sclField, buf);
    }

    protected OffsetStrategy getOffsetStrategy() {
        return OffsetStrategy.SCAN;
    }

    protected long generateKeySelectMax(SRecordMeta<?> rec, SFieldScalar keyFld) {
        StringBuffer qry = new StringBuffer("SELECT MAX(");
        this.appendColumnName(keyFld, qry);
        qry.append(") FROM ");
        this.appendTableName(rec, qry);
        Object next = this.getSession().rawQuerySingle(qry.toString(), false, new Object[0]);
        long db = next == null ? 0L : (next instanceof Number ? ((Number)next).longValue() : Long.parseLong(next.toString()));
        return keyFld.nextGeneratedValue(db + 1L);
    }

    public boolean supportsKeySequences() {
        return false;
    }

    protected long generateKeySequence(SRecordMeta<?> rec, SFieldScalar keyFld) {
        throw new SException.Error("Database does not support SEQUENCES");
    }

    protected String createSequenceDDL(String name) {
        throw new SException.Error("Sequences not supported");
    }

    protected String dropSequenceDDL(String name) {
        throw new SException.Error("Sequences not supported");
    }

    public boolean supportsInsertKeyGeneration() {
        return false;
    }

    protected long retrieveInsertedKey(SRecordMeta<?> rec, SFieldScalar keyFld) {
        throw new SException.Error("Database does not support INSERT IDENTITY");
    }

    public void dropTableNoError(String table) {
        Connection con = this.session.getJdbcConnection();
        try {
            PreparedStatement ps = con.prepareStatement("DROP TABLE " + table);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.getLogger().warn("DROPPING " + table + ": " + ex);
        }
    }

    public SSessionJdbc getSession() {
        return this.session;
    }

    public SLog getLogger() {
        return this.getSession().getLogger();
    }

    static {
        SDriver[] ds = new SDriver[]{new SDriverHSQL(), new SDriverH2(), new SDriverPostgres(), new SDriverMySQL(), new SDriverOracle(), new SDriverMSSQL(), new SDriverDB2_400(), new SDriverInformix(), new SDriverInterbase(), new SDriverFirebird(), new SDriverSapDB(), new SDriverSybase(), new SDriverDerby()};
        for (int dx = 0; dx < ds.length; ++dx) {
            ds[dx].registerDriver();
        }
    }

    public static enum OffsetStrategy {
        JDBC,
        QUERY,
        SCAN;

    }
}

