/*
 * Decompiled with CFR 0.152.
 */
package simpleorm.sessionjdbc;

import simpleorm.dataset.SFieldMeta;
import simpleorm.dataset.SFieldScalar;
import simpleorm.dataset.SRecordInstance;
import simpleorm.dataset.SRecordMeta;
import simpleorm.sessionjdbc.SGeneratorInsertIdentity;
import simpleorm.sessionjdbc.SGeneratorSelectMax;
import simpleorm.sessionjdbc.SGeneratorSequence;
import simpleorm.sessionjdbc.SSessionJdbc;
import simpleorm.utils.SException;

public abstract class SGenerator {
    SFieldScalar keyField;
    SRecordMeta<?> record;
    String generatorName = null;

    SGenerator(SFieldScalar field, String name) {
        this.keyField = field;
        this.record = field.getRecordMeta();
        this.generatorName = name;
    }

    public static void setNewGenerator(SFieldScalar fld) {
        SGenerator gen = (SGenerator)fld.getGenerator();
        if (gen == null) {
            if (fld.getGeneratorMode() == null) {
                throw new SException.Error("No generator mode specified for " + fld);
            }
            switch (fld.getGeneratorMode()) {
                case SSELECT_MAX: {
                    gen = new SGeneratorSelectMax(fld, (String)fld.getGeneratorParameter()[0]);
                    break;
                }
                case SSEQUENCE: {
                    gen = new SGeneratorSequence(fld, (String)fld.getGeneratorParameter()[0]);
                    break;
                }
                case SINSERT: {
                    gen = new SGeneratorInsertIdentity(fld);
                }
            }
            fld.setGenerator((Object)gen);
        }
    }

    public String getName() {
        return this.generatorName;
    }

    SRecordInstance createWithGeneratedKey(SSessionJdbc session, SRecordMeta<?> meta) {
        if (meta != this.record) {
            throw new SException.Error("Inconsistent record metas " + this.record + " !=" + meta);
        }
        long gened = this.generateKey(session, meta, this.keyField);
        Object newRec = session.create(meta, new Long(gened));
        if (session.getLogger().enableQueries()) {
            session.getLogger().queries("createWithGeneratedKey: " + newRec);
        }
        return newRec;
    }

    void preUpdateWithGeneratedKey(SSessionJdbc session, SRecordInstance instance) {
        SRecordMeta meta = instance.getMeta();
        if (meta != this.record) {
            throw new SException.Error("Inconsistent record metas " + this.record + " !=" + meta);
        }
        long gened = this.generateKey(session, meta, this.keyField);
        instance.setLong((SFieldMeta)this.keyField, gened);
        if (session.getLogger().enableQueries()) {
            session.getLogger().queries("updateWithGeneratedKey: " + instance);
        }
    }

    void postUpdateWithGeneratedKey(SSessionJdbc session, SRecordInstance instance) {
    }

    public long generateKey(SSessionJdbc session, SRecordMeta<?> meta, SFieldScalar keyField) {
        throw new SException.Error("generateKey not implemented for " + keyField);
    }

    public String createDDL(SSessionJdbc session) {
        return null;
    }

    public String dropDDL(SSessionJdbc session) {
        return null;
    }

    SRecordMeta<?> getRecordMeta() {
        return this.record;
    }

    public String toString() {
        return "[Generator " + this.keyField + ": " + this.keyField.getGeneratorMode() + "]";
    }
}

