/*
 * Decompiled with CFR 0.152.
 */
package simpleorm.sessionjdbc;

import java.sql.ResultSet;
import java.util.List;
import simpleorm.dataset.SFieldMeta;
import simpleorm.dataset.SFieldScalar;
import simpleorm.dataset.SQuery;
import simpleorm.dataset.SQueryMode;
import simpleorm.dataset.SQueryResult;
import simpleorm.dataset.SQueryTable;
import simpleorm.dataset.SRecordInstance;
import simpleorm.sessionjdbc.SDriver;
import simpleorm.sessionjdbc.SSessionJdbc;
import simpleorm.utils.SException;
import simpleorm.utils.SLog;

class SQueryExecute<RI extends SRecordInstance> {
    SSessionJdbc session = null;
    SQuery<RI> query = null;
    String sqlQuery = null;

    SQueryExecute(SSessionJdbc session, SQuery<RI> query) {
        this.session = session;
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SQueryResult<RI> executeQuery() {
        SQueryResult sQueryResult;
        this.session.statistics.incrementNrQueryDatabase();
        ResultSet rs = null;
        try {
            this.sqlQuery = this.query.getRawSql() != null ? this.query.getRawSql() : this.session.getDriver().selectSQL(this.selectClause(), this.fromClause(), this.joinClause(), this.whereClause(), null, this.orderByClause(), this.query.getQueryMode() == SQueryMode.SFOR_UPDATE, this.query.getLimit(), this.query.getOffset());
            rs = this.session.executeQuery(this.query.getOffset(), this.sqlQuery, this.query.getQueryParameters());
            SQueryResult al = new SQueryResult(this.sqlQuery);
            int ax = 0;
            while ((long)ax < this.query.getLimit() && this.session.rsNext(rs)) {
                RI ri = this.findOrCreateFromResultSet(rs);
                ri.doQueryRecord();
                al.add(ri);
                ++ax;
            }
            sQueryResult = al;
        }
        catch (Throwable throwable) {
            SSessionJdbc.closeResultSetAndStatement(rs);
            throw throwable;
        }
        SSessionJdbc.closeResultSetAndStatement(rs);
        return sQueryResult;
    }

    private RI findOrCreateFromResultSet(ResultSet rs) {
        SRecordInstance result = null;
        for (SQueryTable tbl : this.query.getTables()) {
            if (tbl.getSelectList().length <= 0) continue;
            SRecordInstance inst = this.session.getDataSet().newInstanceNotInDataSet(tbl.getRecordMeta());
            this.session.sessionHelper.retrieveRecord(inst, tbl.getSelectList(), tbl.getFirstFieldIndex(), rs, this.query.getQueryMode() == SQueryMode.SREAD_ONLY, false);
            SLog logger = this.session.getLogger();
            if (!this.isNullRecord(inst)) {
                SRecordInstance cache = this.session.getDataSet().findUsingPrototype(inst);
                if (cache == null || this.session.sessionHelper.needsRequery(cache, this.query.getQueryMode() == SQueryMode.SREAD_ONLY, tbl.getSelectList())) {
                    this.session.getDataSet().pokeIntoDataSet(inst);
                    if (logger.enableQueries()) {
                        logger.queries("getRecord: " + inst + " (from database)");
                    }
                } else {
                    inst = cache;
                    if (cache.getDataSet() != this.session.getDataSet()) {
                        throw new SException.Error("Inconsistent Connections " + cache + cache.getDataSet() + this.session.getDataSet());
                    }
                    if (logger.enableQueries()) {
                        logger.queries("getRecord: " + cache + " (from cache)");
                    }
                }
            }
            if (!SQueryTable.JoinType.MAIN_TABLE.equals((Object)tbl.getType())) continue;
            result = inst;
        }
        return (RI)result;
    }

    String getSQL() {
        return this.sqlQuery;
    }

    private boolean isNullRecord(SRecordInstance inst) {
        for (SFieldScalar pk : inst.getMeta().getPrimaryKeys()) {
            if (inst.isNull((SFieldMeta)pk)) continue;
            return false;
        }
        return true;
    }

    protected String joinClause() {
        StringBuffer sb = new StringBuffer();
        if (this.query.getRawJoin() != null) {
            sb.append(this.query.getRawJoin());
        }
        for (SQueryTable table : this.query.getTables()) {
            if (SQueryTable.JoinType.MAIN_TABLE.equals((Object)table.getType())) continue;
            sb.append(this.getDriver().joinSQL(table)).append(this.getDriver().clauseSeparator("    "));
        }
        return sb.toString();
    }

    protected String whereClause() {
        SQuery.Where where = this.query.getWhere();
        StringBuffer res = new StringBuffer(50);
        this.doWhere(where, res);
        return res.length() > 0 ? res.toString() : null;
    }

    protected void doWhere(SQuery.Where where, StringBuffer res) {
        if (where != null) {
            if (where.getAllRaw() != null) {
                res.append(where.getAllRaw());
            } else {
                if (where.getLeft() != null) {
                    this.doWhere(where.getLeft(), res);
                } else {
                    this.getDriver().appendField(where.getLeftTable(), where.getLeftField(), res);
                }
                res.append(" ");
                res.append(where.getOperator());
                res.append(" ");
                if (where.getRight() != null) {
                    this.doWhere(where.getRight(), res);
                } else if (where.getRightRaw() != null) {
                    res.append(" ");
                    res.append(where.getRightRaw());
                    res.append(" ");
                } else {
                    this.getDriver().appendField(where.getRightTable(), where.getRightField(), res);
                }
            }
        }
    }

    protected String selectClause() {
        StringBuffer selectBuf = new StringBuffer();
        boolean first = true;
        List tables = this.query.getTables();
        if (tables.size() == 1 && this.query.getRawJoin() == null) {
            for (SFieldScalar sfld : ((SQueryTable)tables.get(0)).getSelectList()) {
                if (!first) {
                    selectBuf.append(", ");
                }
                this.getDriver().appendColumnName(sfld, selectBuf);
                first = false;
            }
        } else {
            for (SQueryTable rel : tables) {
                for (SFieldScalar sfld : rel.getSelectList()) {
                    if (!first) {
                        selectBuf.append(", ");
                    }
                    this.getDriver().appendField(rel, sfld, selectBuf);
                    first = false;
                }
            }
        }
        return selectBuf.toString();
    }

    protected String fromClause() {
        return this.getDriver().fromSQL((SQueryTable)this.query.getTables().get(0));
    }

    protected String orderByClause() {
        StringBuffer res = new StringBuffer(30);
        for (SQuery.OrderBy ob = this.query.getOrderBy(); ob != null; ob = ob.getNext()) {
            if (res.length() > 0) {
                res.append(", ");
            }
            if (ob.getRaw() != null) {
                res.append(ob.getRaw());
                continue;
            }
            SFieldScalar sclField = (SFieldScalar)ob.getField();
            this.getDriver().appendField(ob.getTable(), sclField, res);
            if (ob.isAscending()) continue;
            res.append(" DESC");
        }
        return res.length() > 0 ? res.toString() : null;
    }

    protected String queryToString(SQuery<?> query) {
        String res = "[SQuerySql " + query.getRecordMeta() + " WHERE " + this.whereClause() + " ORDER " + this.orderByClause() + "]";
        return res;
    }

    SDriver getDriver() {
        return this.session.getDriver();
    }

    public SQuery<?> getQuery() {
        return this.query;
    }

    public String toString() {
        return "[SPreparedStatement " + this.sqlQuery + "]";
    }
}

