/*
 * Decompiled with CFR 0.152.
 */
package simpleorm.sessionjdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import simpleorm.dataset.SQueryMode;
import simpleorm.dataset.SQueryResult;
import simpleorm.dataset.SQueryTable;
import simpleorm.dataset.SQueryTransient;
import simpleorm.dataset.SRecordInstance;
import simpleorm.dataset.SRecordTransient;
import simpleorm.sessionjdbc.SDriver;
import simpleorm.sessionjdbc.SQueryExecute;
import simpleorm.sessionjdbc.SSessionJdbc;
import simpleorm.utils.SException;

class SQueryTransientExecute<RI extends SRecordInstance>
extends SQueryExecute<RI> {
    SQueryTransient aggregateQuery;

    SQueryTransientExecute(SSessionJdbc session, SQueryTransient aggQuery) {
        super(session, aggQuery.getUnderlyingQuery());
        this.aggregateQuery = aggQuery;
    }

    @Override
    SQueryResult<RI> executeQuery() {
        throw new SException.InternalError("executeQuery called on an SQueryTransientExecute, probably instead of executeAggregateQuery");
    }

    SQueryResult<SRecordTransient> executeAggregateQuery() {
        SQueryResult sQueryResult;
        this.session.statistics.incrementNrQueryDatabase();
        ResultSet rs = null;
        try {
            this.sqlQuery = this.buildSqlQuery();
            rs = this.session.executeQuery(this.query.getOffset(), this.sqlQuery, this.query.getQueryParameters());
            SQueryResult result = new SQueryResult(this.sqlQuery);
            int ax = 0;
            while ((long)ax < this.query.getLimit() && this.session.rsNext(rs)) {
                SRecordTransient row = this.createFromResultSet(rs);
                result.add((Object)row);
                ++ax;
            }
            sQueryResult = result;
        }
        catch (SQLException e) {
            try {
                throw new SException.Jdbc((Throwable)e);
            }
            catch (Throwable throwable) {
                SSessionJdbc.closeResultSetAndStatement(rs);
                throw throwable;
            }
        }
        SSessionJdbc.closeResultSetAndStatement(rs);
        return sQueryResult;
    }

    String buildSqlQuery() {
        return this.session.getDriver().selectSQL(this.selectClause(), this.getDriver().fromSQL((SQueryTable)this.query.getTables().get(0)), this.joinClause(), this.whereClause(), this.groupByClause(), this.orderByClause(), this.query.getQueryMode() == SQueryMode.SFOR_UPDATE, this.query.getLimit(), this.query.getOffset());
    }

    private SRecordTransient createFromResultSet(ResultSet rs) throws SQLException {
        SRecordTransient res = new SRecordTransient();
        int rx = 0;
        for (SQueryTransient.AggregateField fld : this.aggregateQuery.getFields()) {
            res.put(fld.getFieldAlias(), rs.getObject(rx + 1));
            ++rx;
        }
        return res;
    }

    @Override
    protected String selectClause() {
        StringBuffer selectBuf = new StringBuffer();
        boolean first = true;
        for (SQueryTransient.AggregateField fld : this.aggregateQuery.getFields()) {
            if (!first) {
                selectBuf.append(", ");
            }
            this.appendAggField(selectBuf, fld);
            selectBuf.append(" AS ").append(fld.getFieldAlias());
            first = false;
        }
        return selectBuf.toString();
    }

    protected String groupByClause() {
        List fields = this.aggregateQuery.getFields();
        StringBuffer res = new StringBuffer(30);
        for (SQueryTransient.AggregateField fld : fields) {
            if (!fld.getFunction().equals((Object)SQueryTransient.AggregateField.AggregateFunction.GROUP)) continue;
            if (res.length() > 0) {
                res.append(", ");
            }
            if (fld.getRawSelect() != null) {
                res.append(fld.getRawSelect());
                continue;
            }
            this.getDriver().appendField(fld.getTable(), fld.getField(), res);
        }
        return res.length() > 0 ? res.toString() : null;
    }

    @Override
    protected String orderByClause() {
        StringBuffer res = new StringBuffer(30);
        for (SQueryTransient.OrderBy ob = this.aggregateQuery.getOrderBy(); ob != null; ob = ob.getNext()) {
            if (res.length() > 0) {
                res.append(", ");
            }
            this.appendAggField(res, ob.getAggField());
            if (ob.isAscending()) continue;
            res.append(" DESC");
        }
        return res.length() > 0 ? res.toString() : null;
    }

    private void appendAggField(StringBuffer sb, SQueryTransient.AggregateField fld) {
        if (!fld.getFunction().equals((Object)SQueryTransient.AggregateField.AggregateFunction.GROUP) && !fld.getFunction().equals((Object)SQueryTransient.AggregateField.AggregateFunction.COUNT_DISTINCT)) {
            sb.append(" ").append(fld.getFunction().toString()).append("(");
        }
        if (fld.getFunction().equals((Object)SQueryTransient.AggregateField.AggregateFunction.COUNT_DISTINCT)) {
            sb.append(" ").append("COUNT ( DISTINCT ");
        }
        if (fld.getField() != null) {
            if (this.query.getTables().size() == 1 && this.query.getRawJoin() == null) {
                this.getDriver().appendColumnName(fld.getField(), sb);
            } else {
                this.getDriver().appendField(fld.getTable(), fld.getField(), sb);
            }
        } else if (fld.getFunction().equals((Object)SQueryTransient.AggregateField.AggregateFunction.COUNT)) {
            sb.append("*");
        } else {
            sb.append(" ").append(fld.getRawSelect());
        }
        if (!fld.getFunction().equals((Object)SQueryTransient.AggregateField.AggregateFunction.GROUP)) {
            sb.append(")");
        }
    }

    @Override
    SDriver getDriver() {
        return this.session.getDriver();
    }

    @Override
    public String toString() {
        return "[SPreparedStatement " + this.sqlQuery + "]";
    }
}

