/*
 * Decompiled with CFR 0.152.
 */
package simpleorm.sessionjdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import simpleorm.dataset.SDataSet;
import simpleorm.dataset.SFieldScalar;
import simpleorm.dataset.SQuery;
import simpleorm.dataset.SQueryMode;
import simpleorm.dataset.SQueryResult;
import simpleorm.dataset.SQueryTransient;
import simpleorm.dataset.SRecordGeneric;
import simpleorm.dataset.SRecordInstance;
import simpleorm.dataset.SRecordMeta;
import simpleorm.dataset.SRecordTransient;
import simpleorm.dataset.SSelectMode;
import simpleorm.dataset.SSessionI;
import simpleorm.sessionjdbc.SDriver;
import simpleorm.sessionjdbc.SGenerator;
import simpleorm.sessionjdbc.SQueryExecute;
import simpleorm.sessionjdbc.SQueryTransientExecute;
import simpleorm.sessionjdbc.SSessionJdbcHelper;
import simpleorm.sessionjdbc.SStatistics;
import simpleorm.utils.SException;
import simpleorm.utils.SLog;
import simpleorm.utils.SUte;

public class SSessionJdbc
extends SSessionI {
    private static ThreadLocal<SSessionJdbc> threadSConnection = new ThreadLocal();
    private static long nrCons = 0L;
    private DataSource dataSource;
    private SDriver sDriver = null;
    Thread thread = Thread.currentThread();
    final SQueryMode DEFAULTQM = SQueryMode.SBASIC;
    SStatistics statistics = new SStatistics(this);
    private boolean flushed = false;
    SSessionJdbcHelper sessionHelper = new SSessionJdbcHelper(this);
    Connection jdbcConnection = null;
    private long conNr;
    String name = "";
    SDataSet dataSet = null;

    public static SSessionJdbc open(Connection con, String connectionName, SDriver driver) {
        SSessionJdbc ses = new SSessionJdbc();
        ses.innerOpen(con, connectionName, driver);
        return ses;
    }

    public static SSessionJdbc open(DataSource source, String connectionName, SDriver driver) {
        Connection con = null;
        try {
            con = source.getConnection();
        }
        catch (Exception ex) {
            throw new SException.Jdbc("Opening " + source, (Throwable)ex);
        }
        SSessionJdbc ses = SSessionJdbc.open(con, connectionName, driver);
        ses.dataSource = source;
        return ses;
    }

    public static SSessionJdbc open(DataSource source, String connectionName) {
        return SSessionJdbc.open(source, connectionName, null);
    }

    public static SSessionJdbc open(Connection con, String connectionName) {
        return SSessionJdbc.open(con, connectionName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerOpen(Connection con, String connectionName, SDriver driver) {
        this.name = connectionName;
        Class<SSessionJdbc> clazz = SSessionJdbc.class;
        synchronized (SSessionJdbc.class) {
            this.conNr = ++nrCons;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            SSessionJdbc badscon = SSessionJdbc.getThreadLocalSession();
            if (badscon != null) {
                throw new SException.Error("Thread's SSession already open " + (Object)((Object)badscon));
            }
            try {
                if (con == null || con.isClosed()) {
                    throw new SException.Error("Connection " + con + " is not open.");
                }
            }
            catch (Exception ex) {
                throw new SException.Jdbc((Throwable)ex);
            }
            this.jdbcConnection = con;
            this.associateWithThread();
            this.sDriver = driver == null ? SDriver.newSDriver(con) : driver;
            this.sDriver.session = this;
            try {
                if (this.jdbcConnection.getAutoCommit()) {
                    this.jdbcConnection.setAutoCommit(false);
                }
            }
            catch (Exception ex) {
                throw new SException.Jdbc((Throwable)ex);
            }
            if (this.getLogger().enableDebug()) {
                String jvsn = Package.getPackage("java.lang").getImplementationVersion();
                this.getLogger().connections("Attached Connection " + (Object)((Object)this) + " SimpleORM " + SUte.simpleormVersion() + " jdk " + jvsn);
            }
            return;
        }
    }

    protected void associateWithThread() {
        threadSConnection.set(this);
    }

    protected void dissassociateFromThread() {
        threadSConnection.set(null);
    }

    public static SSessionJdbc getThreadLocalSession() {
        return threadSConnection.get();
    }

    public void close() {
        this.closeCon(this.jdbcConnection);
        this.closeSession();
    }

    private void closeCon(Connection con) {
        boolean isOpen = false;
        try {
            isOpen = con != null && !con.isClosed();
        }
        catch (Exception ex) {
            throw new SException.Jdbc("isClosed ", (Throwable)ex);
        }
        if (isOpen) {
            try {
                con.rollback();
            }
            catch (Exception ex) {
                throw new SException.Jdbc("Error rollback " + con, (Throwable)ex);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception ex) {
                    throw new SException.Jdbc("Error closing " + con, (Throwable)ex);
                }
            }
        }
    }

    private void closeSession() {
        this.getLogger().connections("Detaching Connection " + (Object)((Object)this));
        if (this.hasBegun()) {
            this.getLogger().error("Transaction has unflushed updated records.  This is normally caused by an unrelated Exception throwing to the finally block in which case ignore this message.  But if no other exception then a commit() probably missing.\n");
        }
        this.destroyAll();
        this.jdbcConnection = null;
        this.dissassociateFromThread();
    }

    public SSessionJdbc detachFromThread() {
        SSessionJdbc session = threadSConnection.get();
        this.getLogger().connections("unsafeDetachFromThread " + (Object)((Object)session));
        if (session == null || session != this) {
            throw new SException.Error("Session is not associated with thread " + (Object)((Object)session) + (Object)((Object)this));
        }
        threadSConnection.set(null);
        this.thread = null;
        return session;
    }

    public void attachToThread() {
        SSessionJdbc scon = threadSConnection.get();
        if (scon != null) {
            throw new SException.Error("This thread already has connection " + (Object)((Object)scon));
        }
        threadSConnection.set(this);
        this.thread = Thread.currentThread();
        this.getLogger().connections("unsafeAttachToThread " + (Object)((Object)this));
    }

    protected SSessionJdbc() {
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void begin() {
        this.begin(new SDataSet());
    }

    public void begin(SDataSet ds) {
        this.checkThread();
        if (this.hasBegun()) {
            throw new SException.Error("Transaction already Begun.");
        }
        if (this.dataSet != null) {
            throw new SException.InternalError("Non empty existing session dataset/update list.");
        }
        if (ds.getSession() != null) {
            throw new SException.Error("DataSet already has a session " + ds + ds.getSession());
        }
        ds.bindSession((SSessionI)this);
        this.dataSet = ds;
        this.flushed = false;
        this.getLogger().connections("Begun Connection " + (Object)((Object)this));
    }

    public boolean hasBegun() {
        return this.dataSet != null;
    }

    void checkBegunThread() {
        this.checkThread();
        if (!this.hasBegun()) {
            throw new SException.Error("Transaction already committed, need begin.");
        }
    }

    void checkThread() {
        if (this.thread != null && this.thread != Thread.currentThread()) {
            throw new SException.Error("Session created on thread " + this.thread + " but now used in thread " + Thread.currentThread());
        }
    }

    public void commit() {
        this.flush();
        this.innerCommit();
        this.destroyAll();
        this.dataSet = null;
    }

    public SDataSet commitAndDetachDataSet() {
        this.flush();
        this.innerCommit();
        SDataSet ds = this.dataSet;
        ds.unbindSession();
        this.dataSet = null;
        return ds;
    }

    public SDataSet detachUnflushedDataSet() {
        if (this.flushed) {
            throw new SException.Error("Trying to detach a flushed DataSet. **That has not been committed or rolled back**");
        }
        SDataSet ds = this.dataSet;
        ds.unbindSession();
        this.dataSet = null;
        try {
            this.jdbcConnection.rollback();
        }
        catch (SQLException e) {
            throw new SException.Jdbc("While releasing the transaction ", (Throwable)e);
        }
        return ds;
    }

    private void innerCommit() {
        this.statistics.incrementNrTransactions();
        this.flushed = false;
        try {
            this.jdbcConnection.commit();
        }
        catch (Exception ex) {
            throw new SException.Jdbc((Throwable)ex);
        }
        this.getLogger().connections("Committed Connection " + (Object)((Object)this));
    }

    public void rollback() {
        this.innerRollback();
        this.destroyAll();
        this.dataSet = null;
    }

    public SDataSet rollBackAndDetachDataSet() {
        this.innerRollback();
        SDataSet ds = this.dataSet;
        ds.unbindSession();
        this.dataSet = null;
        return ds;
    }

    private void innerRollback() {
        this.checkBegunThread();
        this.statistics.incrementNrTransactions();
        this.flushed = false;
        try {
            this.jdbcConnection.rollback();
        }
        catch (Exception ex) {
            throw new SException.Jdbc((Throwable)ex);
        }
        this.getLogger().connections("Rolled Back Connection " + (Object)((Object)this));
    }

    public void setTransactionIsolation(int mode) {
        try {
            this.jdbcConnection.setTransactionIsolation(mode);
        }
        catch (SQLException se) {
            throw new SException.Jdbc("While setting isolation mode " + mode, (Throwable)se);
        }
    }

    public void flush() {
        this.checkBegunThread();
        for (int rx = 0; rx < this.dataSet.getDirtyRecords().size(); ++rx) {
            SRecordInstance ri = (SRecordInstance)this.dataSet.getDirtyRecords().get(rx);
            if (ri == null) continue;
            this.flush(ri);
        }
        this.dataSet.clearDirtyList();
    }

    public void flush(SRecordInstance instance) {
        this.checkBegunThread();
        this.sessionHelper.flush(instance);
        this.flushed = true;
    }

    public void flushAndPurge(SRecordInstance ri) {
        this.checkBegunThread();
        this.sessionHelper.flush(ri);
        this.dataSet.removeRecord(ri);
    }

    public void flushAndPurge() {
        this.checkBegunThread();
        this.flush();
        if (this.dataSet == null) {
            return;
        }
        this.dataSet.purge();
    }

    void destroyAll() {
        if (this.dataSet == null) {
            return;
        }
        this.dataSet.destroy();
        this.dataSet = null;
    }

    public String toString() {
        return "[SS " + this.conNr + "." + this.name + "]";
    }

    public <RI extends SRecordInstance> SQueryResult<RI> queryNoFlush(SQuery<RI> qry) {
        this.checkBegunThread();
        SQueryExecute<RI> qXeq = this.getDriver().queryExecuteFactory(this, qry);
        return qXeq.executeQuery();
    }

    public <RI extends SRecordInstance> SQueryResult<RI> query(SQuery<RI> qry) {
        this.flush();
        return this.queryNoFlush(qry);
    }

    public SQueryResult<SRecordTransient> queryTransientNoFlush(SQueryTransient qry) {
        this.checkBegunThread();
        SQueryTransientExecute qXeq = this.getDriver().queryExecuteFactory(this, qry);
        return qXeq.executeAggregateQuery();
    }

    public SQueryResult<SRecordTransient> queryTransient(SQueryTransient qry) {
        this.flush();
        return this.queryTransientNoFlush(qry);
    }

    public <RI extends SRecordInstance> RI findOrCreate(SRecordMeta<RI> rmeta, SFieldScalar[] selectList, SQueryMode queryMode, Object ... keys) {
        return this.sessionHelper.doFindOrCreate(rmeta, selectList, queryMode, true, keys);
    }

    public <RI extends SRecordInstance> RI findOrCreate(SRecordMeta<RI> rmeta, SSelectMode selectMode, SQueryMode queryMode, Object ... keys) {
        return this.findOrCreate(rmeta, rmeta.fieldsForMode(selectMode), queryMode, keys);
    }

    public <RI extends SRecordInstance> RI findOrCreate(SRecordMeta<RI> rmeta, SSelectMode selectMode, Object ... keys) {
        return this.findOrCreate(rmeta, selectMode, this.DEFAULTQM, keys);
    }

    public <RI extends SRecordInstance> RI findOrCreate(SRecordMeta<RI> rmeta, SQueryMode queryMode, Object ... keys) {
        return this.findOrCreate(rmeta, SSelectMode.SNORMAL, queryMode, keys);
    }

    public <RI extends SRecordInstance> RI findOrCreate(SRecordMeta<RI> rmeta, Object ... keys) {
        return this.findOrCreate(rmeta, SSelectMode.SNORMAL, keys);
    }

    public <RI extends SRecordInstance> RI mustFind(SRecordMeta<RI> rmeta, SQueryMode queryMode, Object ... keys) {
        RI found = this.find(rmeta, queryMode, keys);
        if (found == null) {
            throw new SException.Data("Record not found " + SUte.arrayToString((Object)keys));
        }
        return found;
    }

    public <RI extends SRecordInstance> RI mustFind(SRecordMeta<RI> rmeta, Object ... keys) {
        return this.mustFind(rmeta, this.DEFAULTQM, keys);
    }

    public <RI extends SRecordInstance> RI find(SRecordMeta<RI> rmeta, SFieldScalar[] selectList, SQueryMode queryMode, Object ... keys) {
        return this.sessionHelper.doFindOrCreate(rmeta, selectList, queryMode, false, keys);
    }

    public <RI extends SRecordInstance> RI find(SRecordMeta<RI> rmeta, SQueryMode queryMode, Object ... keys) {
        return this.find(rmeta, rmeta.getQueriedScalarFields(), queryMode, keys);
    }

    public <RI extends SRecordInstance> RI find(SRecordMeta<RI> rmeta, Object ... keys) {
        return this.find(rmeta, this.DEFAULTQM, keys);
    }

    public <RI extends SRecordInstance> RI create(SRecordMeta<RI> rmeta, Object ... keys) {
        RI res = this.sessionHelper.doFindOrCreate(rmeta, rmeta.fieldsForMode(SSelectMode.SNORMAL), SQueryMode.SASSUME_CREATE, true, keys);
        res.assertNewRow();
        return res;
    }

    public <RI extends SRecordInstance> RI createWithGeneratedKey(SRecordMeta<RI> rmeta) {
        SRecordInstance newRec;
        block1: {
            this.checkBegunThread();
            newRec = null;
            SFieldScalar[] arr$ = rmeta.getPrimaryKeys();
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ >= len$) break block1;
            SFieldScalar key = arr$[i$];
            SGenerator.setNewGenerator(key);
            SGenerator gen = (SGenerator)key.getGenerator();
            if (gen != null) {
                newRec = gen.createWithGeneratedKey(this, rmeta);
            }
        }
        return (RI)newRec;
    }

    public void dirtyPurge(SRecordInstance rinst) {
        this.dataSet.removeRecord(rinst);
    }

    public int rawUpdateDB(String sql, Object ... params) {
        this.flush();
        return this.rawUpdateDBNoFlush(sql, params);
    }

    public int rawUpdateDBNoFlush(String sql, Object ... params) {
        this.getLogger().updates("rawDB " + sql);
        int res = -1;
        if (sql != null) {
            if (!this.hasBegun()) {
                throw new SException.Error("Transaction not begin()ed.");
            }
            PreparedStatement ps = null;
            try {
                ps = this.jdbcConnection.prepareStatement(sql);
                for (int px = 0; px < params.length; ++px) {
                    ps.setObject(px + 1, params[px]);
                }
                res = ps.executeUpdate();
            }
            catch (Exception ex) {
                throw new SException.Jdbc("SQL: " + sql, (Throwable)ex);
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception ex) {
                    throw new SException.Jdbc((Throwable)ex);
                }
            }
        }
        return res;
    }

    public SQueryResult<SRecordGeneric> rawQuery(String sql, boolean flush, Object ... params) {
        if (flush) {
            this.flush();
        }
        return this.rawQueryInner(sql, params);
    }

    public Object rawQuerySingle(String sql, boolean flush, Object ... params) {
        SQueryResult<SRecordGeneric> result;
        SRecordGeneric record;
        Set columns;
        if (flush) {
            this.flush();
        }
        if ((columns = (record = (result = this.rawQueryInner(sql, params)).oneOrNone()).entrySet()).size() > 1) {
            throw new SException.Error("Only one column can be returned " + sql);
        }
        Iterator i$ = columns.iterator();
        if (i$.hasNext()) {
            Map.Entry col = (Map.Entry)i$.next();
            return col.getValue();
        }
        return null;
    }

    private SQueryResult<SRecordGeneric> rawQueryInner(String sql, Object[] params) {
        SQueryResult sQueryResult;
        ResultSet rs = null;
        try {
            rs = this.executeQuery(0L, sql, Arrays.asList(params));
            ResultSetMetaData metaData = rs.getMetaData();
            SQueryResult res = new SQueryResult(sql);
            while (rs.next()) {
                SRecordTransient ares = new SRecordTransient();
                for (int rx = 0; rx < metaData.getColumnCount(); ++rx) {
                    ares.put(metaData.getColumnName(rx + 1), rs.getObject(rx + 1));
                }
                res.add((Object)ares);
            }
            if (this.getLogger().enableQueries()) {
                this.getLogger().queries("rawJDBC " + sql + SUte.arrayToString((Object)params));
            }
            if (this.getLogger().enableFields()) {
                this.getLogger().fields(" ---> " + res);
            }
            sQueryResult = res;
        }
        catch (Exception ex) {
            try {
                throw new SException.Jdbc((Throwable)ex);
            }
            catch (Throwable throwable) {
                SSessionJdbc.closeResultSetAndStatement(rs);
                throw throwable;
            }
        }
        SSessionJdbc.closeResultSetAndStatement(rs);
        return sQueryResult;
    }

    protected ResultSet executeQuery(long offset, String sqlQuery, List<Object> params) {
        this.checkBegunThread();
        PreparedStatement ps = this.prepareStatement(offset, sqlQuery, params);
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            this.offsetResultSet(rs, offset);
        }
        catch (Exception rsex) {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    throw new SException.Jdbc("Executing " + sqlQuery, (Throwable)rsex);
                }
            }
            throw new SException.Jdbc("Executing " + sqlQuery, (Throwable)rsex);
        }
        return rs;
    }

    private PreparedStatement prepareStatement(long offset, String sqlQuery, List<Object> params) {
        if (this.getLogger().enableQueries()) {
            this.getLogger().queries("Selecting " + SSessionJdbcHelper.substituteToString(sqlQuery, params));
        }
        Statement jdbcPreparedStatement = null;
        try {
            int RsType = 1003;
            if (offset != 0L && this.getDriver().getOffsetStrategy().equals((Object)SDriver.OffsetStrategy.JDBC)) {
                RsType = 1004;
            }
            jdbcPreparedStatement = this.getJdbcConnection().prepareStatement(sqlQuery, RsType, 1007);
        }
        catch (Exception psex) {
            if (jdbcPreparedStatement != null) {
                try {
                    jdbcPreparedStatement.close();
                }
                catch (SQLException e) {
                    throw new SException.Jdbc("Preparing '" + sqlQuery + "'", (Throwable)psex);
                }
            }
            throw new SException.Jdbc("Preparing '" + sqlQuery + "'", (Throwable)psex);
        }
        for (int px = 0; px < params.size(); ++px) {
            try {
                jdbcPreparedStatement.setObject(px + 1, params.get(px));
                continue;
            }
            catch (Exception se) {
                if (jdbcPreparedStatement != null) {
                    try {
                        jdbcPreparedStatement.close();
                    }
                    catch (SQLException e) {
                        throw new SException.Jdbc("Setting " + (Object)((Object)this) + " '?' " + (px + 1), (Throwable)se);
                    }
                }
                throw new SException.Jdbc("Setting " + (Object)((Object)this) + " '?' " + (px + 1), (Throwable)se);
            }
        }
        return jdbcPreparedStatement;
    }

    private void offsetResultSet(ResultSet rs, long offset) {
        Statement ps = null;
        try {
            if (SDriver.OffsetStrategy.JDBC.equals((Object)this.getDriver().getOffsetStrategy()) && offset != 0L) {
                rs.setFetchDirection(1002);
                rs.absolute((int)offset);
            } else if (SDriver.OffsetStrategy.SCAN.equals((Object)this.getDriver().getOffsetStrategy())) {
                boolean next = true;
                int rx = 0;
                while (next && (long)rx < offset) {
                    next = rs.next();
                    ++rx;
                }
            }
        }
        catch (Exception ex) {
            if (rs != null) {
                try {
                    ps = rs.getStatement();
                }
                catch (SQLException rsex) {
                    throw new SException.Jdbc("Applying offset " + offset + " to resultSet", (Throwable)ex);
                }
                finally {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e) {
                            throw new SException.Jdbc("Applying offset " + offset + " to resultSet", (Throwable)ex);
                        }
                    }
                }
            }
            throw new SException.Jdbc("Applying offset " + offset + " to resultSet", (Throwable)ex);
        }
    }

    protected boolean rsNext(ResultSet rs) {
        Statement ps = null;
        try {
            return rs.next();
        }
        catch (SQLException ex) {
            if (rs != null) {
                try {
                    ps = rs.getStatement();
                }
                catch (SQLException rsex) {
                    throw new SException.Jdbc("Moving forward in rs " + rs, (Throwable)ex);
                }
                finally {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e) {
                            throw new SException.Jdbc("Moving forward in rs " + rs, (Throwable)ex);
                        }
                    }
                }
            }
            throw new SException.Jdbc("Moving forward in rs " + rs, (Throwable)ex);
        }
    }

    public SLog getLogger() {
        if (this.getDataSet() != null) {
            return this.getDataSet().getLogger();
        }
        return SLog.getSessionlessLogger();
    }

    public Connection getJdbcConnection() {
        return this.jdbcConnection;
    }

    public SDataSet getDataSet() {
        return this.dataSet;
    }

    public SDriver getDriver() {
        return this.sDriver;
    }

    public SStatistics getStatistics() {
        return this.statistics;
    }

    protected static void closeResultSetAndStatement(ResultSet rs) {
        Statement ps = null;
        try {
            if (rs != null && (ps = rs.getStatement()) == null) {
                throw new SException.InternalError("Could not get the statement from the resultSet");
            }
        }
        catch (Exception e1) {
            throw new SException.Jdbc("Closing rs ", (Throwable)e1);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e2) {
                throw new SException.Jdbc("Closing ps ", (Throwable)e2);
            }
        }
    }

    public String queryToString(SQueryTransient qry) {
        String sql = this.getDriver().queryExecuteFactory(this, qry).buildSqlQuery();
        StringBuffer buffer = new StringBuffer();
        ArrayList parameters = qry.getUnderlyingQuery().getQueryParameters();
        int fromIndex = 0;
        for (int ii = 0; ii < parameters.size(); ++ii) {
            int index = sql.indexOf(63, fromIndex);
            buffer.append(sql.substring(fromIndex, index));
            buffer.append("'" + parameters.get(ii) + "'");
            fromIndex = index + 1;
        }
        buffer.append(sql.substring(fromIndex));
        return buffer.toString();
    }
}

