/*
 * Decompiled with CFR 0.152.
 */
package simpleorm.sessionjdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import simpleorm.dataset.SFieldMeta;
import simpleorm.dataset.SFieldReference;
import simpleorm.dataset.SFieldScalar;
import simpleorm.dataset.SQueryMode;
import simpleorm.dataset.SRecordInstance;
import simpleorm.dataset.SRecordMeta;
import simpleorm.sessionjdbc.SDriver;
import simpleorm.sessionjdbc.SGenerator;
import simpleorm.sessionjdbc.SSessionJdbc;
import simpleorm.utils.SException;
import simpleorm.utils.SLog;
import simpleorm.utils.SUte;

class SSessionJdbcHelper {
    SSessionJdbc session;

    SSessionJdbcHelper(SSessionJdbc session) {
        this.session = session;
    }

    /*
     * Enabled aggressive block sorting
     */
    public <RI extends SRecordInstance> RI doFindOrCreate(SRecordMeta<RI> rmeta, SFieldScalar[] selectList, SQueryMode queryMode, boolean mayCreate, Object[] keys) {
        SRecordInstance instance;
        this.session.checkBegunThread();
        boolean readOnly = queryMode.equals((Object)SQueryMode.SREAD_ONLY);
        if (this.getLogger().enableFields()) {
            this.getLogger().fields("findOrCreate " + rmeta + " " + SUte.arrayToString((Object)keys));
        }
        if (this.needsRequery(instance = this.session.dataSet.findOrCreate(rmeta, keys), readOnly, selectList)) {
            instance = this.findInDatabase(instance, queryMode, selectList, readOnly);
            if (this.getLogger().enableQueries()) {
                this.getLogger().queries("findOrCreate: " + instance + " (from database)" + (instance.isNewRow() ? " New Row" : " Existing Row"));
            }
            if (instance.isNewRow()) {
                if (!mayCreate) {
                    this.session.dataSet.removeRecord(instance);
                    return null;
                }
                instance.validatePrimaryKeys();
                instance.setDirty(true);
            } else {
                instance.doQueryRecord();
            }
        }
        if (instance.getDataSet() != this.session.dataSet) {
            throw new SException.InternalError("Inconsistent DataSet " + instance + instance.getDataSet() + this);
        }
        if (instance.getMeta() != rmeta) {
            throw new SException.InternalError("Found " + instance + " instead of " + rmeta);
        }
        return (RI)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <RI extends SRecordInstance> RI findInDatabase(RI instance, SQueryMode queryMode, SFieldScalar[] selectList, boolean readOnly) {
        ResultSet rs = null;
        this.session.checkBegunThread();
        this.session.statistics.incrementNrFindInDatabase();
        boolean existing = false;
        if (queryMode.equals((Object)SQueryMode.SASSUME_CREATE)) {
            existing = false;
        } else {
            String qry = this.session.getDriver().selectSQL(selectList, instance.getMeta(), instance.getMeta().getPrimaryKeys(), null, queryMode == SQueryMode.SFOR_UPDATE);
            try {
                ArrayList<Object> qparams = new ArrayList<Object>(6);
                for (SFieldScalar key : instance.getMeta().getPrimaryKeys()) {
                    Object value = instance.getRawArrayValue((SFieldMeta)key);
                    qparams.add(key.writeFieldValue(value));
                    instance.defineInitialValue((SFieldMeta)key);
                }
                if (this.getLogger().enableQueries()) {
                    this.getLogger().queries("findOrCreate querying '" + SSessionJdbcHelper.substituteToString(qry, qparams) + "'...");
                }
                if (this.session.rsNext(rs = this.session.executeQuery(0L, qry, qparams))) {
                    this.retrieveRecord(instance, selectList, 1, rs, readOnly, true);
                    existing = true;
                    if (this.session.rsNext(rs)) {
                        throw new SException.Jdbc("Primary key not unique " + instance);
                    }
                }
            }
            catch (Throwable throwable) {
                SSessionJdbc.closeResultSetAndStatement(rs);
                throw throwable;
            }
            SSessionJdbc.closeResultSetAndStatement(rs);
        }
        instance.setNewRow(!existing);
        instance.setReadOnly(readOnly);
        return instance;
    }

    boolean needsRequery(SRecordInstance rinst, boolean readOnly, SFieldScalar[] selectList) {
        if (rinst.isNewRow()) {
            return false;
        }
        boolean requery = !readOnly && rinst.isReadOnly();
        for (SFieldScalar selF : selectList) {
            boolean bl = requery = requery || !rinst.isValid((SFieldMeta)selF);
            if (requery) break;
        }
        if (requery && rinst.isDirty()) {
            throw new SException.Error("Need to flush dirty before requery " + rinst);
        }
        return requery;
    }

    void flush(SRecordInstance instance) {
        if (!instance.isDirty()) {
            return;
        }
        try {
            this.session.statistics.incrementNrFlushRecord();
            SRecordMeta meta = instance.getMeta();
            if (this.getLogger().enableUpdates()) {
                this.getLogger().updates("Flushing '" + instance + "'" + (!instance.isDirty() ? " ?Not Dirty? " : "") + (instance.isNewRow() ? "INSERT" : (instance.isDeleted() ? "DELETE" : "UPDATE")));
            }
            if (!this.session.hasBegun()) {
                throw new SException.Error("Inconsistent Connections " + instance + instance.getDataSet() + this);
            }
            if (instance.getDataSet() != this.session.getDataSet()) {
                throw new SException.Error("Inconsistent Connections " + instance + instance.getDataSet() + this);
            }
            SGenerator theGenerator = null;
            if (instance.isNewRow() && !instance.isDeleted()) {
                for (SFieldScalar pkey : meta.getPrimaryKeys()) {
                    Object pkval = instance.getObject((SFieldMeta)pkey);
                    if (pkval != null) continue;
                    SGenerator.setNewGenerator(pkey);
                    theGenerator = (SGenerator)pkey.getGenerator();
                    if (theGenerator != null) {
                        theGenerator.preUpdateWithGeneratedKey(this.session, instance);
                        continue;
                    }
                    throw new SException.Error("No generator for null primary key " + pkey);
                }
            }
            if (!instance.isDeleted()) {
                instance.doValidateRecord();
            }
            ArrayList<SFieldScalar> fieldList = new ArrayList<SFieldScalar>(meta.getFieldMetas().size());
            if (!instance.isDeleted()) {
                for (SFieldScalar sfm : meta.getAllScalarFields()) {
                    boolean upd = instance.isNewRow() && sfm.isPrimary();
                    boolean bl = upd = upd || instance.isDirty((SFieldMeta)sfm);
                    if (!upd) continue;
                    fieldList.add(sfm);
                }
            }
            if (!(instance.isNewRow() && instance.isDeleted() || !instance.isDeleted() && fieldList.size() <= 0)) {
                Object value;
                String qry = null;
                Object[] keyMetaValues = new Object[meta.getFieldMetas().size()];
                ArrayList<SFieldScalar> keyMetas = this.keyFieldMetas(instance, keyMetaValues);
                qry = instance.isNewRow() ? this.session.getDriver().insertSQL(fieldList, meta) : (instance.isDeleted() ? this.session.getDriver().deleteSQL(meta, keyMetas, instance, keyMetaValues) : this.session.getDriver().updateSQL(fieldList, meta, keyMetas, instance, keyMetaValues));
                Connection con = this.session.jdbcConnection;
                PreparedStatement ps = null;
                ps = this.flushPreparedStatement(con, qry, instance);
                int jx = 0;
                ArrayList<Object> parameters = new ArrayList<Object>(20);
                if (!instance.isDeleted()) {
                    for (SFieldScalar fieldMeta : fieldList) {
                        try {
                            ++jx;
                            parameters.add(instance.getRawArrayValue((SFieldMeta)fieldMeta));
                            value = instance.getRawArrayValue((SFieldMeta)fieldMeta);
                            if (value == null && fieldMeta.isPrimary() && theGenerator == null) {
                                throw new SException.Error("Null primary key not set (after createWithNullKey) " + instance);
                            }
                            if (value == null) {
                                ps.setNull(jx, fieldMeta.javaSqlType());
                                continue;
                            }
                            fieldMeta.writeFieldValue(ps, jx, instance.getRawArrayValue((SFieldMeta)fieldMeta));
                        }
                        catch (Exception se) {
                            throw new SException.Jdbc("Setting Values " + instance + "'" + qry + "' Field " + fieldMeta, (Throwable)se).setInstance(instance);
                        }
                    }
                }
                if (!instance.isNewRow()) {
                    for (int kx = 0; kx < keyMetas.size(); ++kx) {
                        SFieldScalar fieldMeta;
                        fieldMeta = keyMetas.get(kx);
                        try {
                            value = fieldMeta.writeFieldValue(instance.getInitialValue((SFieldMeta)fieldMeta));
                        }
                        catch (Exception se) {
                            throw new SException.Jdbc("Converting optimistic field value '" + instance + " '" + qry + "' " + jx + keyMetas.get(kx) + " = " + instance.getRawArrayValue((SFieldMeta)fieldMeta), (Throwable)se).setInstance(instance);
                        }
                        if (value == null) continue;
                        ++jx;
                        if (this.getLogger().enableFields()) {
                            this.getLogger().fields("Where " + instance + jx + keyMetas.get(kx) + " = " + value);
                        }
                        try {
                            parameters.add(value);
                            ps.setObject(jx, value);
                            continue;
                        }
                        catch (Exception se) {
                            throw new SException.Jdbc("Setting  " + instance + " '" + qry + "' " + jx + keyMetas.get(kx) + " = " + value, (Throwable)se).setInstance(instance);
                        }
                    }
                }
                if (this.getLogger().enableQueries()) {
                    this.getLogger().queries("FlushSQL " + SSessionJdbcHelper.substituteToString(qry, parameters));
                }
                int result = 0;
                result = this.flushExecuteUpdate(ps, qry, instance);
                if (result == 0) {
                    throw new SRecordInstance.BrokenOptimisticLockException(instance);
                }
                try {
                    ps.close();
                }
                catch (Exception cl1) {
                    throw new SException.Jdbc("Closing " + instance, (Throwable)cl1).setInstance(instance);
                }
                if (theGenerator != null) {
                    theGenerator.postUpdateWithGeneratedKey(this.session, instance);
                }
                for (SFieldScalar cfld : fieldList) {
                    instance.defineInitialValue((SFieldMeta)cfld);
                }
            }
            instance.setDirty(false);
            instance.setNewRow(false);
            if (instance.isDeleted()) {
                instance.getDataSet().removeRecord(instance);
            }
            return;
        }
        catch (SException sex) {
            throw sex;
        }
        catch (Exception ex) {
            throw new SException.Jdbc("While flushing " + instance, (Throwable)ex).setRecordInstance(instance);
        }
    }

    private int flushExecuteUpdate(PreparedStatement ps, String qry, SRecordInstance instance) {
        int result;
        try {
            result = ps.executeUpdate();
        }
        catch (Exception rsex) {
            throw new SException.Jdbc("Executing " + qry + " for " + instance, (Throwable)rsex).setInstance(instance);
        }
        return result;
    }

    private PreparedStatement flushPreparedStatement(Connection con, String qry, SRecordInstance instance) {
        PreparedStatement ps;
        try {
            ps = con.prepareStatement(qry);
        }
        catch (Exception psex) {
            throw new SException.Jdbc("Preparing " + instance + "'" + qry + "'", (Throwable)psex).setInstance(instance);
        }
        return ps;
    }

    ArrayList<SFieldScalar> keyFieldMetas(SRecordInstance instance, Object[] keyMetaValues) {
        ArrayList<SFieldScalar> res = new ArrayList<SFieldScalar>();
        int addCounter = 0;
        for (SFieldMeta fld : instance.getMeta().getFieldMetas()) {
            SFieldScalar sclFld;
            if (fld instanceof SFieldReference || (sclFld = (SFieldScalar)fld).isNotOptimisticLocked() || !instance.isValid(fld) || (!instance.isDirty(fld) || instance.isNewRow()) && !((SFieldScalar)fld).isPrimary()) continue;
            res.add(sclFld);
            keyMetaValues[addCounter++] = instance.getInitialValue(fld);
        }
        return res;
    }

    void retrieveRecord(SRecordInstance inst, SFieldScalar[] selectList, int beginIndex, ResultSet rs, boolean readOnly, boolean checkPrimaryKey) {
        Object qvalue = null;
        for (SFieldScalar fMeta : selectList) {
            qvalue = null;
            try {
                qvalue = fMeta.queryFieldValue(rs, beginIndex);
            }
            catch (Exception ge) {
                throw new SException.Jdbc("Getting Field " + beginIndex + " from " + this, (Throwable)ge);
            }
            if (checkPrimaryKey && fMeta.isPrimary() && (qvalue == null || !SUte.trimStringEquals((Object)qvalue, (Object)inst.getRawArrayValue((SFieldMeta)fMeta)))) {
                throw new SException.InternalError("Bad PKey " + qvalue.getClass() + " '" + qvalue + "' !equal() '" + inst.getRawArrayValue((SFieldMeta)fMeta).getClass() + "' " + inst.getRawArrayValue((SFieldMeta)fMeta));
            }
            inst.setRawArrayValue((SFieldMeta)fMeta, qvalue);
            inst.defineInitialValue((SFieldMeta)fMeta);
            inst.setReadOnly(readOnly);
            ++beginIndex;
        }
        inst.setReadOnly(readOnly);
    }

    SLog getLogger() {
        return this.session.getLogger();
    }

    SDriver getDriver() {
        return this.session.getDriver();
    }

    public static String substituteToString(String qry, List<Object> parameters) {
        StringBuffer buffer = new StringBuffer();
        int fromIndex = 0;
        for (int ii = 0; ii < parameters.size(); ++ii) {
            int index = qry.indexOf(63, fromIndex);
            buffer.append(qry.substring(fromIndex, index));
            buffer.append("?=" + parameters.get(ii) + "?");
            fromIndex = index + 1;
        }
        buffer.append(qry.substring(fromIndex));
        return buffer.toString();
    }
}

