/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.ByteBufferInputStream;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.PdfSubByteSampleModel;
import com.sun.pdfview.colorspace.IndexedColor;
import com.sun.pdfview.colorspace.PDFColorSpace;
import com.sun.pdfview.decode.PDFDecoder;
import java.awt.Color;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PackedColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;

public class PDFImage {
    private static int[][] GREY_TO_ARGB = new int[8][];
    private int[] colorKeyMask = null;
    private int width;
    private int height;
    private PDFColorSpace colorSpace;
    private int bpc;
    private boolean imageMask = false;
    private PDFImage sMask;
    private float[] decode;
    private float[] decodeMins;
    private float[] decodeCoefficients;
    private PDFObject imageObj;

    public static void dump(PDFObject obj) throws IOException {
        PDFImage.p("dumping PDF object: " + obj);
        if (obj == null) {
            return;
        }
        HashMap<String, PDFObject> dict = obj.getDictionary();
        PDFImage.p("   dict = " + dict);
        for (String key : dict.keySet()) {
            PDFImage.p("key = " + key + " value = " + dict.get(key));
        }
    }

    public static void p(String string) {
        System.out.println(string);
    }

    private static int[] getGreyToArgbMap(int numBits) {
        assert (numBits <= 8);
        int[] argbVals = GREY_TO_ARGB[numBits - 1];
        if (argbVals == null) {
            argbVals = PDFImage.createGreyToArgbMap(numBits);
        }
        return argbVals;
    }

    private static int[] createGreyToArgbMap(int numBits) {
        ColorSpace greyCs = PDFColorSpace.getColorSpace(0).getColorSpace();
        byte[] greyVals = new byte[1 << numBits];
        for (int i = 0; i < greyVals.length; ++i) {
            greyVals[i] = (byte)(i & 0xFF);
        }
        int[] argbVals = new int[greyVals.length];
        int mask = (1 << numBits) - 1;
        WritableRaster inRaster = Raster.createPackedRaster(new DataBufferByte(greyVals, greyVals.length), greyVals.length, 1, greyVals.length, new int[]{mask}, null);
        BufferedImage greyImage = new BufferedImage(new PdfComponentColorModel(greyCs, new int[]{numBits}), inRaster, false, null);
        ColorModel ccm = ColorModel.getRGBdefault();
        WritableRaster outRaster = Raster.createPackedRaster(new DataBufferInt(argbVals, argbVals.length), argbVals.length, 1, argbVals.length, ((PackedColorModel)ccm).getMasks(), null);
        BufferedImage srgbImage = new BufferedImage(ccm, outRaster, false, null);
        ColorConvertOp op = new ColorConvertOp(greyCs, ColorSpace.getInstance(1000), null);
        op.filter(greyImage, srgbImage);
        PDFImage.GREY_TO_ARGB[numBits - 1] = argbVals;
        return argbVals;
    }

    protected PDFImage(PDFObject imageObj) {
        this.imageObj = imageObj;
    }

    public static PDFImage createImage(PDFObject obj, Map resources) throws IOException {
        PDFImage image = new PDFImage(obj);
        PDFObject widthObj = obj.getDictRef("Width");
        if (widthObj == null) {
            throw new PDFParseException("Unable to read image width: " + obj);
        }
        image.setWidth(widthObj.getIntValue());
        PDFObject heightObj = obj.getDictRef("Height");
        if (heightObj == null) {
            throw new PDFParseException("Unable to get image height: " + obj);
        }
        image.setHeight(heightObj.getIntValue());
        PDFObject imageMaskObj = obj.getDictRef("ImageMask");
        if (imageMaskObj != null) {
            image.setImageMask(imageMaskObj.getBooleanValue());
        }
        if (image.isImageMask()) {
            PDFObject[] array;
            float decode0;
            image.setBitsPerComponent(1);
            Color[] colors = new Color[]{Color.BLACK, Color.WHITE};
            PDFObject imageMaskDecode = obj.getDictRef("Decode");
            if (imageMaskDecode != null && (decode0 = (array = imageMaskDecode.getArray())[0].getFloatValue()) == 1.0f) {
                colors = new Color[]{Color.WHITE, Color.BLACK};
            }
            image.setColorSpace(new IndexedColor(colors));
        } else {
            PDFObject bpcObj = obj.getDictRef("BitsPerComponent");
            if (bpcObj == null) {
                throw new PDFParseException("Unable to get bits per component: " + obj);
            }
            image.setBitsPerComponent(bpcObj.getIntValue());
            PDFObject csObj = obj.getDictRef("ColorSpace");
            if (csObj == null) {
                throw new PDFParseException("No ColorSpace for image: " + obj);
            }
            PDFColorSpace cs = PDFColorSpace.getColorSpace(csObj, resources);
            image.setColorSpace(cs);
        }
        PDFObject decodeObj = obj.getDictRef("Decode");
        if (decodeObj != null) {
            PDFObject[] decodeArray = decodeObj.getArray();
            float[] decode = new float[decodeArray.length];
            for (int i = 0; i < decodeArray.length; ++i) {
                decode[i] = decodeArray[i].getFloatValue();
            }
            image.setDecode(decode);
        }
        if (imageMaskObj == null) {
            PDFObject sMaskObj = obj.getDictRef("SMask");
            if (sMaskObj == null) {
                sMaskObj = obj.getDictRef("Mask");
            }
            if (sMaskObj != null) {
                if (sMaskObj.getType() == 7) {
                    try {
                        PDFImage sMaskImage = PDFImage.createImage(sMaskObj, resources);
                        image.setSMask(sMaskImage);
                    }
                    catch (IOException ex) {
                        PDFImage.p("ERROR: there was a problem parsing the mask for this object");
                        PDFImage.dump(obj);
                        ex.printStackTrace(System.out);
                    }
                } else if (sMaskObj.getType() == 5) {
                    try {
                        image.setColorKeyMask(sMaskObj);
                    }
                    catch (IOException ex) {
                        PDFImage.p("ERROR: there was a problem parsing the color mask for this object");
                        PDFImage.dump(obj);
                        ex.printStackTrace(System.out);
                    }
                }
            }
        }
        return image;
    }

    public BufferedImage getImage() {
        try {
            BufferedImage bi = (BufferedImage)this.imageObj.getCache();
            if (bi == null) {
                byte[] data = null;
                ByteBuffer jpegBytes = null;
                boolean jpegDecode = PDFDecoder.isLastFilter(this.imageObj, PDFDecoder.DCT_FILTERS);
                if (jpegDecode) {
                    jpegBytes = this.imageObj.getStreamBuffer(PDFDecoder.DCT_FILTERS);
                } else {
                    data = this.imageObj.getStream();
                }
                bi = this.parseData(data, jpegBytes);
                this.imageObj.setCache(bi);
            }
            return bi;
        }
        catch (IOException ioe) {
            System.out.println("Error reading image");
            ioe.printStackTrace();
            return null;
        }
    }

    protected BufferedImage parseData(byte[] data, ByteBuffer jpegData) throws IOException {
        ColorModel cm = this.getColorModel();
        BufferedImage bi = null;
        if (jpegData != null) {
            ImageReader jpegReader = ImageIO.getImageReadersByFormatName("jpeg").next();
            jpegReader.setInput(ImageIO.createImageInputStream(new ByteBufferInputStream(jpegData)), true, false);
            if (this.getDecode() != null) {
                ImageReadParam param = new ImageReadParam();
                SampleModel sm = cm.createCompatibleSampleModel(this.getWidth(), this.getHeight());
                WritableRaster raster = Raster.createWritableRaster(sm, new Point(0, 0));
                param.setDestination(new BufferedImage(cm, raster, true, null));
                bi = jpegReader.read(0, param);
                jpegData = null;
            } else {
                bi = new BufferedImage(cm, jpegReader.read(0).getRaster(), true, null);
            }
        } else {
            WritableRaster raster;
            DataBufferByte db = new DataBufferByte(data, data.length);
            SampleModel sm = cm.createCompatibleSampleModel(this.getWidth(), this.getHeight());
            try {
                raster = Raster.createWritableRaster(sm, db, new Point(0, 0));
            }
            catch (RasterFormatException e) {
                int calculatedLineBits = this.getWidth() * this.getColorSpace().getNumComponents() * this.getBitsPerComponent();
                int calculatedLineBytes = calculatedLineBits + 0;
                int calculatedBytes = calculatedLineBytes * this.getHeight();
                if (calculatedBytes > data.length) {
                    byte[] tempLargerData = new byte[calculatedBytes];
                    System.arraycopy(data, 0, tempLargerData, 0, data.length);
                    db = new DataBufferByte(tempLargerData, calculatedBytes);
                    raster = Raster.createWritableRaster(sm, db, new Point(0, 0));
                }
                throw e;
            }
            if (cm instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)cm;
                int type = 12;
                if (this.getBitsPerComponent() == 8) {
                    type = 13;
                }
                bi = new BufferedImage(this.getWidth(), this.getHeight(), type, icm);
                bi.setData(raster);
            } else {
                bi = new BufferedImage(cm, raster, true, null);
            }
        }
        ColorSpace cs = cm.getColorSpace();
        ColorSpace rgbCS = ColorSpace.getInstance(1000);
        if (this.isGreyscale(cs) && this.bpc <= 8 && this.getDecode() == null && jpegData == null) {
            bi = this.convertGreyscaleToArgb(data, bi);
        } else if (!this.isImageMask() && cs instanceof ICC_ColorSpace && !cs.equals(rgbCS)) {
            ColorConvertOp op = new ColorConvertOp(cs, rgbCS, null);
            BufferedImage converted = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            bi = op.filter(bi, converted);
        }
        PDFImage sMaskImage = this.getSMask();
        if (sMaskImage != null) {
            BufferedImage si = sMaskImage.getImage();
            BufferedImage outImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            int[] srcArray = new int[this.width];
            int[] maskArray = new int[this.width];
            for (int i = 0; i < this.height; ++i) {
                bi.getRGB(0, i, this.width, 1, srcArray, 0, this.width);
                si.getRGB(0, i, this.width, 1, maskArray, 0, this.width);
                for (int j = 0; j < this.width; ++j) {
                    int ac = -16777216;
                    maskArray[j] = (maskArray[j] & 0xFF) << 24 | srcArray[j] & ~ac;
                }
                outImage.setRGB(0, i, this.width, 1, maskArray, 0, this.width);
            }
            bi = outImage;
        }
        return bi;
    }

    private boolean isGreyscale(ColorSpace aCs) {
        return aCs == PDFColorSpace.getColorSpace(0).getColorSpace();
    }

    private BufferedImage convertGreyscaleToArgb(byte[] data, BufferedImage bi) {
        int y;
        int[] convertedPixels = new int[this.getWidth() * this.getHeight()];
        WritableRaster r = bi.getRaster();
        int i = 0;
        int[] greyToArgbMap = PDFImage.getGreyToArgbMap(this.bpc);
        if (this.bpc == 1) {
            assert (greyToArgbMap[0] == 0);
            assert (greyToArgbMap[1] == -1);
            for (y = 0; y < this.getHeight(); ++y) {
                for (int x = 0; x < this.getWidth(); ++x) {
                    byte b = data[i / 8];
                    int white = b >> 7 - (i & 7) & 1;
                    convertedPixels[i] = 0xFF000000 | white - 1 ^ 0xFFFFFF;
                    ++i;
                }
            }
        } else {
            for (y = 0; y < this.getHeight(); ++y) {
                for (int x = 0; x < this.getWidth(); ++x) {
                    int greyscale = r.getSample(x, y, 0);
                    convertedPixels[i] = greyToArgbMap[greyscale];
                    ++i;
                }
            }
        }
        ColorModel ccm = ColorModel.getRGBdefault();
        return new BufferedImage(ccm, Raster.createPackedRaster(new DataBufferInt(convertedPixels, convertedPixels.length), this.getWidth(), this.getHeight(), this.getWidth(), ((PackedColorModel)ccm).getMasks(), null), false, null);
    }

    public int getWidth() {
        return this.width;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    private void setColorKeyMask(PDFObject maskArrayObject) throws IOException {
        PDFObject[] maskObjects = maskArrayObject.getArray();
        this.colorKeyMask = null;
        int[] masks = new int[maskObjects.length];
        for (int i = 0; i < masks.length; ++i) {
            masks[i] = maskObjects[i].getIntValue();
        }
        this.colorKeyMask = masks;
    }

    protected PDFColorSpace getColorSpace() {
        return this.colorSpace;
    }

    protected void setColorSpace(PDFColorSpace colorSpace) {
        this.colorSpace = colorSpace;
    }

    protected int getBitsPerComponent() {
        return this.bpc;
    }

    protected void setBitsPerComponent(int bpc) {
        this.bpc = bpc;
    }

    public boolean isImageMask() {
        return this.imageMask;
    }

    public void setImageMask(boolean imageMask) {
        this.imageMask = imageMask;
    }

    public PDFImage getSMask() {
        return this.sMask;
    }

    protected void setSMask(PDFImage sMask) {
        this.sMask = sMask;
    }

    protected float[] getDecode() {
        return this.decode;
    }

    protected void setDecode(float[] decode) {
        float max = (1 << this.getBitsPerComponent()) - 1;
        this.decode = decode;
        this.decodeCoefficients = new float[decode.length / 2];
        this.decodeMins = new float[decode.length / 2];
        for (int i = 0; i < decode.length; i += 2) {
            this.decodeMins[i / 2] = decode[i];
            this.decodeCoefficients[i / 2] = (decode[i + 1] - decode[i]) / max;
        }
    }

    private ColorModel getColorModel() {
        PDFColorSpace cs = this.getColorSpace();
        if (cs instanceof IndexedColor) {
            int i;
            int correctCount;
            IndexedColor ics = (IndexedColor)cs;
            byte[] components = ics.getColorComponents();
            int num = ics.getCount();
            if (this.decode != null) {
                byte[] normComps = new byte[components.length];
                for (int i2 = 0; i2 < num; ++i2) {
                    byte[] orig = new byte[]{(byte)i2};
                    float[] res = this.normalize(orig, null, 0);
                    int idx = (int)res[0];
                    normComps[i2 * 3] = components[idx * 3];
                    normComps[i2 * 3 + 1] = components[idx * 3 + 1];
                    normComps[i2 * 3 + 2] = components[idx * 3 + 2];
                }
                components = normComps;
            }
            if ((correctCount = 1 << this.getBitsPerComponent()) < num) {
                byte[] fewerComps = new byte[correctCount * 3];
                System.arraycopy(components, 0, fewerComps, 0, correctCount * 3);
                components = fewerComps;
                num = correctCount;
            }
            if (this.colorKeyMask == null || this.colorKeyMask.length == 0) {
                return new IndexColorModel(this.getBitsPerComponent(), num, components, 0, false);
            }
            byte[] aComps = new byte[num * 4];
            int idx = 0;
            for (i = 0; i < num; ++i) {
                aComps[idx++] = components[i * 3];
                aComps[idx++] = components[i * 3 + 1];
                aComps[idx++] = components[i * 3 + 2];
                aComps[idx++] = -1;
            }
            for (i = 0; i < this.colorKeyMask.length; i += 2) {
                for (int j = this.colorKeyMask[i]; j <= this.colorKeyMask[i + 1]; ++j) {
                    aComps[j * 4 + 3] = 0;
                }
            }
            return new IndexColorModel(this.getBitsPerComponent(), num, aComps, 0, true);
        }
        int[] bits = new int[cs.getNumComponents()];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = this.getBitsPerComponent();
        }
        return this.decode != null ? new DecodeComponentColorModel(cs.getColorSpace(), bits) : new PdfComponentColorModel(cs.getColorSpace(), bits);
    }

    private float[] normalize(byte[] pixels, float[] normComponents, int normOffset) {
        if (normComponents == null) {
            normComponents = new float[normOffset + pixels.length];
        }
        switch (pixels.length) {
            case 4: {
                normComponents[normOffset + 3] = this.decodeMins[3] + (float)(pixels[3] & 0xFF) * this.decodeCoefficients[3];
            }
            case 3: {
                normComponents[normOffset + 2] = this.decodeMins[2] + (float)(pixels[2] & 0xFF) * this.decodeCoefficients[2];
            }
            case 2: {
                normComponents[normOffset + 1] = this.decodeMins[1] + (float)(pixels[1] & 0xFF) * this.decodeCoefficients[1];
            }
            case 1: {
                normComponents[normOffset] = this.decodeMins[0] + (float)(pixels[0] & 0xFF) * this.decodeCoefficients[0];
                break;
            }
            default: {
                throw new IllegalArgumentException("Someone needs to add support for more than 4 components");
            }
        }
        return normComponents;
    }

    class DecodeComponentColorModel
    extends PdfComponentColorModel {
        DecodeComponentColorModel(ColorSpace cs, int[] bpc) {
            super(cs, bpc);
        }

        public int getRGB(Object inData) {
            float[] norm;
            float[] rgb = norm = this.getNormalizedComponents(inData, null, 0);
            return this.getAlpha(inData) << 24 | (int)(rgb[0] * 255.0f + 0.5f) << 16 | (int)(rgb[1] * 255.0f + 0.5f) << 8 | (int)(rgb[2] * 255.0f + 0.5f);
        }

        public float[] getNormalizedComponents(Object pixel, float[] normComponents, int normOffset) {
            return PDFImage.this.normalize((byte[])pixel, normComponents, normOffset);
        }
    }

    static class PdfComponentColorModel
    extends ComponentColorModel {
        int bitsPerComponent;

        public PdfComponentColorModel(ColorSpace cs, int[] bpc) {
            super(cs, bpc, false, false, 1, 0);
            this.pixel_bits = bpc.length * bpc[0];
            this.bitsPerComponent = bpc[0];
        }

        public SampleModel createCompatibleSampleModel(int width, int height) {
            if (this.bitsPerComponent >= 8) {
                assert (this.bitsPerComponent == 8 || this.bitsPerComponent == 16);
                int numComponents = this.getNumComponents();
                int[] bandOffsets = new int[numComponents];
                for (int i = 0; i < numComponents; ++i) {
                    bandOffsets[i] = i;
                }
                return new PixelInterleavedSampleModel(this.getTransferType(), width, height, numComponents, width * numComponents, bandOffsets);
            }
            switch (this.getPixelSize()) {
                case 1: 
                case 2: 
                case 4: {
                    return new MultiPixelPackedSampleModel(this.getTransferType(), width, height, this.getPixelSize());
                }
            }
            assert (this.getTransferType() == 0);
            return new PdfSubByteSampleModel(width, height, this.getNumComponents(), this.bitsPerComponent);
        }

        public boolean isCompatibleRaster(Raster raster) {
            if (this.bitsPerComponent < 8 || this.getNumComponents() == 1) {
                SampleModel sm = raster.getSampleModel();
                return sm.getSampleSize(0) == this.bitsPerComponent;
            }
            return super.isCompatibleRaster(raster);
        }
    }
}

